/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.items;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class QuestBookItem
extends Item {
    private static final String NBT_PLAYER = "UseAsPlayer";
    private final boolean enabled;

    public QuestBookItem(boolean enabled) {
        super(new Item.Properties().m_41487_(1));
        this.enabled = enabled;
    }

    public static ItemStack getOPBook(Player player) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.enabledBook.get());
        CompoundTag nbt = stack.m_41698_("hqm");
        nbt.m_128359_(NBT_PLAYER, player.m_20148_().toString());
        stack.m_41700_("hqm", (Tag)nbt);
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        if (world.f_46443_ && Quest.isEditing && !HQMUtil.isSinglePlayerOnly()) {
            Quest.setEditMode(false);
        }
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ItemStack stack = player.m_21120_(hand);
            QuestingDataManager questingData = QuestingDataManager.getInstance();
            if (!questingData.isQuestActive()) {
                player.m_213846_((Component)Translator.translatable("hqm.message.noQuestYet", new Object[0]));
            } else if (this.enabled) {
                CompoundTag compound = stack.m_41737_("hqm");
                if (compound != null && compound.m_128441_(NBT_PLAYER)) {
                    UUID uuid;
                    String uuidS = compound.m_128461_(NBT_PLAYER);
                    try {
                        uuid = UUID.fromString(uuidS);
                    }
                    catch (IllegalArgumentException e) {
                        compound.m_128473_(NBT_PLAYER);
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    if (questingData.hasData(uuid)) {
                        if (HardcoreQuestingCore.getServer().m_129944_(player.m_36316_()) >= 4) {
                            Player subject = QuestingData.getPlayer(uuid);
                            if (subject instanceof ServerPlayer) {
                                EventTrigger.instance().onBookOpening(new EventTrigger.BookOpeningEvent(player.m_20148_(), true, false));
                                PlayerEntry entry = questingData.getQuestingData(subject).getTeam().getEntry(subject.m_20148_());
                                if (entry != null) {
                                    GeneralUsage.sendOpenBook(player, true);
                                } else {
                                    player.m_213846_((Component)Translator.translatable("hqm.message.bookNoEntry", new Object[0]));
                                }
                            }
                        } else {
                            player.m_213846_((Component)Translator.translatable("hqm.message.bookNoPermission", new Object[0]));
                        }
                    } else {
                        player.m_213846_((Component)Translator.translatable("hqm.message.bookNoData", new Object[0]));
                    }
                }
            } else {
                EventTrigger.instance().onBookOpening(new EventTrigger.BookOpeningEvent(player.m_20148_(), false, true));
                PlayerEntry entry = questingData.getQuestingData(player).getTeam().getEntry(player.m_20148_());
                if (entry != null) {
                    GeneralUsage.sendOpenBook(player, false);
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"hqm.message.bookNoPlayer"));
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.enabled) {
            CompoundTag compound = stack.m_41737_("hqm");
            if (compound != null && compound.m_128441_(NBT_PLAYER)) {
                Player useAsPlayer = QuestingData.getPlayer(compound.m_128461_(NBT_PLAYER));
                tooltip.add((Component)Translator.translatable("item.hqm:quest_book_1.useAs", useAsPlayer == null ? "INVALID" : useAsPlayer.m_6302_()));
            } else {
                tooltip.add((Component)Translator.translatable("item.hqm:quest_book_1.invalid", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return this.enabled;
    }
}

