/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.GuiReward;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.GeneralUpdateMessage;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeneralUsage {
    BOOK_OPEN{

        @Override
        public void receiveData(Player player, CompoundTag nbt) {
            GuiQuestBook.displayGui(player, nbt.m_128471_("OP"));
        }
    }
    ,
    BOOK_SELECT_TASK{

        @Override
        public void receiveData(Player player, CompoundTag nbt) {
            QuestingData data = QuestingDataManager.getInstance().getQuestingData(player);
            data.selectedQuestId = nbt.m_128342_("QuestId");
            data.selectedTask = nbt.m_128451_("TaskId");
        }
    }
    ,
    BAG_OPENED{

        @Override
        public void receiveData(Player player, CompoundTag nbt) {
            UUID groupId = nbt.m_128342_("GroupId");
            int bag = nbt.m_128451_("Bag");
            int[] limits = nbt.m_128465_("Limits");
            GuiReward.open(player, groupId, bag, limits);
        }
    };


    public static void sendOpenBook(Player player, boolean op) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("OP", op);
        BOOK_OPEN.sendMessageToPlayer(nbt, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendBookSelectTaskUpdate(QuestTask task) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("QuestId", task.getParent().getQuestId());
        nbt.m_128405_("TaskId", task.getId());
        BOOK_SELECT_TASK.sendMessageToServer(nbt);
    }

    public static void sendOpenBagUpdate(Player player, UUID groupId, int bag, int[] limits) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("GroupId", groupId);
        nbt.m_128405_("Bag", bag);
        nbt.m_128385_("Limits", limits);
        BAG_OPENED.sendMessageToPlayer(nbt, player);
    }

    public abstract void receiveData(Player var1, CompoundTag var2);

    @OnlyIn(value=Dist.CLIENT)
    public void sendMessageToServer(CompoundTag data) {
        NetworkManager.sendToServer(new GeneralUpdateMessage((Player)Minecraft.m_91087_().f_91074_, data, this.ordinal()));
    }

    public void sendMessageToPlayer(CompoundTag data, Player player) {
        if (player instanceof ServerPlayer) {
            NetworkManager.sendToPlayer(new GeneralUpdateMessage(player, data, this.ordinal()), (ServerPlayer)player);
        }
    }
}

