/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network;

import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.ISyncableTile;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.network.message.BlockSyncMessage;
import hardcorequesting.common.forge.network.message.BlockSyncMessageClient;
import hardcorequesting.common.forge.network.message.ClientUpdateMessage;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.network.message.GeneralUpdateMessage;
import hardcorequesting.common.forge.network.message.LivesUpdate;
import hardcorequesting.common.forge.network.message.OpActionMessage;
import hardcorequesting.common.forge.network.message.OpenGuiMessage;
import hardcorequesting.common.forge.network.message.PlayerDataSyncMessage;
import hardcorequesting.common.forge.network.message.QuestDataUpdateMessage;
import hardcorequesting.common.forge.network.message.SoundMessage;
import hardcorequesting.common.forge.network.message.SyncableTileMessage;
import hardcorequesting.common.forge.network.message.TeamErrorMessage;
import hardcorequesting.common.forge.network.message.TeamMessage;
import hardcorequesting.common.forge.network.message.TeamStatsMessage;
import hardcorequesting.common.forge.network.message.TeamUpdateMessage;
import hardcorequesting.common.forge.tileentity.IBlockSync;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;

public class NetworkManager {
    private static final ResourceLocation S2C = new ResourceLocation("hardcorequesting", "s2c");
    private static final ResourceLocation C2S = new ResourceLocation("hardcorequesting", "c2s");
    private static int id = 0;
    private static final Map<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> PACKET_HANDLERS = new HashMap<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>>();

    public static void init() {
        NetworkManager.registerMessage(OpenGuiMessage.Handler.class, OpenGuiMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(PlayerDataSyncMessage.Handler.class, PlayerDataSyncMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamStatsMessage.Handler.class, TeamStatsMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamErrorMessage.Handler.class, TeamErrorMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(QuestDataUpdateMessage.Handler.class, QuestDataUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(DeathStatsMessage.Handler.class, DeathStatsMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(TeamUpdateMessage.Handler.class, TeamUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(SoundMessage.Handler.class, SoundMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(LivesUpdate.Handler.class, LivesUpdate.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(BlockSyncMessageClient.Handler.class, BlockSyncMessageClient.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(BlockSyncMessage.Handler.class, BlockSyncMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(TeamMessage.Handler.class, TeamMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(ClientUpdateMessage.Handler.class, ClientUpdateMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(OpActionMessage.Handler.class, OpActionMessage.class, id++, Dist.DEDICATED_SERVER);
        NetworkManager.registerMessage(SyncableTileMessage.class, SyncableTileMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(GeneralUpdateMessage.class, GeneralUpdateMessage.class, id++, Dist.CLIENT);
        NetworkManager.registerMessage(GeneralUpdateMessage.class, GeneralUpdateMessage.class, id++, Dist.DEDICATED_SERVER);
        if (HardcoreQuestingCore.platform.isClient()) {
            HardcoreQuestingCore.platform.getNetworkManager().registerS2CHandler(S2C, (packetContext, packetByteBuf) -> {
                int id = packetByteBuf.readInt();
                for (Map.Entry<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> entry : PACKET_HANDLERS.entrySet()) {
                    if ((Integer)entry.getValue().m_14419_() != id) continue;
                    try {
                        IMessage message = entry.getKey().newInstance();
                        message.fromBytes((FriendlyByteBuf)packetByteBuf, (PacketContext)packetContext);
                        IMessageHandler handler = entry.getKey() != entry.getValue().m_14418_() ? (IMessageHandler)((Class)entry.getValue().m_14418_()).newInstance() : (IMessageHandler)((Object)message);
                        handler.onMessage(message, (PacketContext)packetContext);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                HardcoreQuestingCore.LOGGER.error("Invalid Packet ID: " + id);
            });
        }
        HardcoreQuestingCore.platform.getNetworkManager().registerC2SHandler(C2S, (packetContext, packetByteBuf) -> {
            int id = packetByteBuf.readInt();
            for (Map.Entry<Class<? extends IMessage>, Tuple<Class<? extends IMessageHandler>, Integer>> entry : PACKET_HANDLERS.entrySet()) {
                if ((Integer)entry.getValue().m_14419_() != id) continue;
                try {
                    IMessage message = entry.getKey().newInstance();
                    message.fromBytes((FriendlyByteBuf)packetByteBuf, (PacketContext)packetContext);
                    IMessageHandler handler = entry.getKey() != entry.getValue().m_14418_() ? (IMessageHandler)((Class)entry.getValue().m_14418_()).newInstance() : (IMessageHandler)((Object)message);
                    handler.onMessage(message, (PacketContext)packetContext);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                return;
            }
            HardcoreQuestingCore.LOGGER.error("Invalid Packet ID: " + id);
        });
    }

    private static void registerMessage(Class<? extends IMessageHandler> handlerClass, Class<? extends IMessage> messageClass, int id, Dist envType) {
        PACKET_HANDLERS.put(messageClass, (Tuple<Class<? extends IMessageHandler>, Integer>)new Tuple(handlerClass, (Object)id));
    }

    public static void sendToPlayer(IMessage message, ServerPlayer player) {
        if (player == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.m_14419_()).intValue());
        message.toBytes(buf);
        HardcoreQuestingCore.platform.getNetworkManager().sendToPlayer(player, S2C, buf);
    }

    public static void sendToAllPlayers(IMessage message) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.m_14419_()).intValue());
        message.toBytes(buf);
        for (ServerPlayer entity : HardcoreQuestingCore.getServer().m_6846_().m_11314_()) {
            HardcoreQuestingCore.platform.getNetworkManager().sendToPlayer(entity, S2C, new FriendlyByteBuf(buf.copy()));
        }
    }

    public static void sendToServer(IMessage message) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.m_14419_()).intValue());
        message.toBytes(buf);
        HardcoreQuestingCore.platform.getNetworkManager().sendToServer(C2S, buf);
    }

    public static void sendToPlayersAround(IMessage message, BlockEntity te, double radius) {
        BlockPos pos = te.m_58899_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Tuple<Class<? extends IMessageHandler>, Integer> pair = PACKET_HANDLERS.get(message.getClass());
        buf.writeInt(((Integer)pair.m_14419_()).intValue());
        message.toBytes(buf);
        Packet<?> packet = HardcoreQuestingCore.platform.getNetworkManager().createToPlayerPacket(S2C, buf);
        HardcoreQuestingCore.getServer().m_6846_().m_11241_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), radius, te.m_58904_().m_46472_(), packet);
    }

    public static <T extends BlockEntity> void sendBlockUpdate(T block, Player player, int type) {
        StringWriter data = new StringWriter();
        boolean onServer = !block.m_58904_().f_46443_;
        try {
            JsonWriter writer = new JsonWriter((Writer)data);
            writer.beginObject();
            ((IBlockSync)block).writeData(player, onServer, type, writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            return;
        }
        if (!onServer) {
            NetworkManager.sendToServer(new BlockSyncMessageClient(block, type, data.toString()));
        } else {
            BlockSyncMessage message = new BlockSyncMessage(block, type, data.toString());
            if (player instanceof ServerPlayer) {
                NetworkManager.sendToPlayer(message, (ServerPlayer)player);
            } else {
                NetworkManager.sendToPlayersAround(message, block, 128.0);
            }
        }
    }

    public static void sendSyncPacket(BlockEntity tile) {
        if (tile instanceof ISyncableTile && !tile.m_58904_().f_46443_) {
            NetworkManager.sendToPlayersAround(new SyncableTileMessage(tile), tile, 128.0);
        }
    }
}

