/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.tileentity.IBlockSync;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockSyncMessage
implements IMessage {
    private long pos;
    private int type;
    private String data;

    public BlockSyncMessage() {
    }

    public BlockSyncMessage(BlockEntity te, int type, String data) {
        this.pos = te.m_58899_().m_121878_();
        this.type = type;
        this.data = data;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        this.pos = buf.readLong();
        this.type = buf.readInt();
        this.data = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.pos);
        buf.writeInt(this.type);
        buf.m_130070_(this.data);
    }

    public static class Handler
    implements IMessageHandler<BlockSyncMessage, IMessage> {
        @Override
        public IMessage onMessage(BlockSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(BlockSyncMessage message, PacketContext ctx) {
            Player player = HardcoreQuestingCore.proxy.getPlayer(ctx);
            if (player == null) {
                return;
            }
            BlockEntity te = player.m_9236_().m_7702_(BlockPos.m_122022_((long)message.pos));
            JsonObject data = new JsonParser().parse(message.data).getAsJsonObject();
            if (te instanceof IBlockSync) {
                ((IBlockSync)te).readData(player, !ctx.isClient(), message.type, data);
            }
        }
    }
}

