/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class GeneralUpdateMessage
implements IMessage,
IMessageHandler<GeneralUpdateMessage, IMessage> {
    private Player player;
    private CompoundTag data;
    private int usage = -1;

    public GeneralUpdateMessage() {
    }

    public GeneralUpdateMessage(Player player, CompoundTag data, int usage) {
        this.player = player;
        this.data = data;
        this.usage = usage;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        UUID playerId = buf.m_130259_();
        this.data = buf.m_130260_();
        this.usage = buf.readInt();
        this.player = context.getPlayer();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player.m_20148_());
        buf.m_130079_(this.data);
        buf.writeInt(this.usage);
    }

    @Override
    public IMessage onMessage(GeneralUpdateMessage message, PacketContext ctx) {
        ctx.getTaskQueue().accept(() -> {
            if (message.data != null && message.usage >= 0) {
                GeneralUsage usage = GeneralUsage.values()[message.usage];
                if (message.player != null) {
                    usage.receiveData(message.player, message.data);
                }
            }
        });
        return null;
    }
}

