/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.LocalDataManager;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.SyncUtil;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDataSyncMessage
implements IMessage {
    private String reputations;
    private String bags;
    private String mainDescription;
    private Map<String, String> questsSets;
    private boolean questing;
    private boolean hardcore;
    private String teams;
    private String data;
    private String deaths;

    public PlayerDataSyncMessage() {
    }

    public PlayerDataSyncMessage(QuestLine questLine, Player player) {
        this.mainDescription = questLine.getMainDescription();
        this.reputations = questLine.reputationManager.saveToString();
        this.bags = questLine.groupTierManager.saveToString();
        this.questsSets = Maps.newLinkedHashMap();
        for (QuestSet set : questLine.questSetsManager.questSets) {
            this.questsSets.put(set.getFilename(), SaveHandler.save(set, QuestSet.class));
        }
        this.questing = questLine.questingDataManager.isQuestActive();
        this.hardcore = questLine.questingDataManager.isHardcoreActive();
        this.teams = questLine.teamManager.saveToString(player);
        this.deaths = questLine.deathStatsManager.saveToString();
        this.data = questLine.questingDataManager.data.saveToString(player);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        this.mainDescription = SyncUtil.readLargeString((ByteBuf)buf);
        this.reputations = SyncUtil.readLargeString((ByteBuf)buf);
        this.bags = SyncUtil.readLargeString((ByteBuf)buf);
        int size = buf.readInt();
        this.questsSets = Maps.newLinkedHashMap();
        for (int i = 0; i < size; ++i) {
            String fileName = SyncUtil.readLargeString((ByteBuf)buf);
            String questSetString = SyncUtil.readLargeString((ByteBuf)buf);
            this.questsSets.put(fileName, questSetString);
        }
        this.questing = buf.readBoolean();
        this.hardcore = buf.readBoolean();
        this.teams = SyncUtil.readLargeString((ByteBuf)buf);
        this.deaths = SyncUtil.readLargeString((ByteBuf)buf);
        this.data = SyncUtil.readLargeString((ByteBuf)buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        SyncUtil.writeLargeString(this.mainDescription, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.reputations, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.bags, (ByteBuf)buf);
        buf.writeInt(this.questsSets.size());
        for (Map.Entry<String, String> entry : this.questsSets.entrySet()) {
            SyncUtil.writeLargeString(entry.getKey(), (ByteBuf)buf);
            SyncUtil.writeLargeString(entry.getValue(), (ByteBuf)buf);
        }
        buf.writeBoolean(this.questing);
        buf.writeBoolean(this.hardcore);
        SyncUtil.writeLargeString(this.teams, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.deaths, (ByteBuf)buf);
        SyncUtil.writeLargeString(this.data, (ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataSyncMessage, IMessage> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public IMessage onMessage(PlayerDataSyncMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message));
            return null;
        }

        @OnlyIn(value=Dist.CLIENT)
        private void handle(PlayerDataSyncMessage message) {
            QuestLine questLine = QuestLine.reset();
            JsonArray sets = new JsonArray();
            for (String s : message.questsSets.keySet()) {
                sets.add(s);
            }
            JsonObject object = new JsonObject();
            object.add("sets", (JsonElement)sets);
            LocalDataManager data = new LocalDataManager();
            data.provide("sets.json", object.toString());
            for (Map.Entry<String, String> entry : message.questsSets.entrySet()) {
                data.provide("sets/" + entry.getKey() + ".json", entry.getValue());
            }
            questLine.questSetsManager.load(data);
            questLine.setMainDescription(message.mainDescription);
            questLine.reputationManager.clearAndLoad(message.reputations);
            questLine.groupTierManager.clearAndLoad(message.bags);
            questLine.teamManager.loadFromString(message.teams);
            questLine.questingDataManager.data.loadFromString(message.data);
            questLine.questingDataManager.state.loadFromString(QuestingDataManager.saveQuestingState(message.questing, message.hardcore));
            questLine.deathStatsManager.loadFromString(message.deaths);
        }
    }
}

