/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.adapter.QuestDataAdapter;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class QuestDataUpdateMessage
implements IMessage {
    private static final Gson GSON = new Gson();
    private UUID questId;
    private String data;
    private int players;

    public QuestDataUpdateMessage() {
    }

    public QuestDataUpdateMessage(UUID questId, int players, QuestData data) {
        this.questId = questId;
        this.data = GSON.toJson(QuestDataAdapter.serialize(data));
        this.players = players;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        this.players = buf.readInt();
        this.questId = buf.m_130259_();
        int charLength = buf.readInt();
        this.data = buf.readCharSequence(charLength, StandardCharsets.UTF_8).toString();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.players);
        buf.m_130077_(this.questId);
        buf.writeInt(this.data.length());
        buf.writeCharSequence((CharSequence)this.data, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<QuestDataUpdateMessage, IMessage> {
        @Override
        public IMessage onMessage(QuestDataUpdateMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(QuestDataUpdateMessage message, PacketContext ctx) {
            try {
                Quest quest = Quest.getQuest(message.questId);
                if (quest != null) {
                    QuestData data = QuestDataAdapter.deserialize((JsonObject)GSON.fromJson(message.data, JsonObject.class), quest);
                    quest.setQuestData(HardcoreQuestingCore.proxy.getPlayer(ctx), data);
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
    }
}

