/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.ISyncableTile;
import hardcorequesting.common.forge.network.PacketContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SyncableTileMessage
implements IMessage,
IMessageHandler<SyncableTileMessage, IMessage> {
    private BlockEntity tileToSync;
    private CompoundTag data;

    public SyncableTileMessage() {
    }

    public SyncableTileMessage(BlockEntity tileToSync) {
        this.tileToSync = tileToSync;
        if (tileToSync instanceof ISyncableTile) {
            this.data = ((ISyncableTile)tileToSync).getSyncData();
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        ResourceLocation worldId = buf.m_130281_();
        BlockPos pos = buf.m_130135_();
        this.data = buf.m_130260_();
        ServerLevel world = HardcoreQuestingCore.getServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)worldId));
        if (world != null) {
            this.tileToSync = world.m_7702_(pos);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.tileToSync.m_58904_().m_46472_().m_135782_());
        buf.m_130064_(this.tileToSync.m_58899_());
        buf.m_130079_(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMessage onMessage(SyncableTileMessage message, PacketContext ctx) {
        ctx.getTaskQueue().accept(() -> {
            if (message.tileToSync instanceof ISyncableTile && message.data != null) {
                System.out.println(message.tileToSync.m_58904_().m_7702_(message.tileToSync.m_58899_()).hashCode());
                ((ISyncableTile)message.tileToSync).onData(message.data);
                System.out.println(message.tileToSync.hashCode());
            }
        });
        return null;
    }
}

