/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.network.message;

import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.IMessageHandler;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;

public class TeamStatsMessage
implements IMessage {
    private List<TeamLiteStat> stats;

    public TeamStatsMessage() {
    }

    public TeamStatsMessage(Team team) {
        this.stats = Collections.singletonList(team.toLiteStat());
    }

    public TeamStatsMessage(Stream<Team> teams) {
        this.stats = teams.map(Team::toLiteStat).collect(Collectors.toList());
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf, PacketContext context) {
        int size = buf.readInt();
        this.stats = new ArrayList<TeamLiteStat>();
        for (int i = 0; i < size; ++i) {
            String name = buf.m_130136_(Short.MAX_VALUE);
            if (name.equals("NULL")) {
                name = null;
            }
            int players = buf.readInt();
            int lives = buf.readInt();
            float progress = buf.readFloat();
            this.stats.add(new TeamLiteStat(name, players, lives, progress));
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.stats.size());
        for (TeamLiteStat teamLiteStat : this.stats) {
            if (teamLiteStat.getName() != null) {
                buf.m_130070_(teamLiteStat.getName());
            } else {
                buf.m_130070_("NULL");
            }
            buf.writeInt(teamLiteStat.getPlayers());
            buf.writeInt(teamLiteStat.getLives());
            buf.writeFloat(teamLiteStat.getProgress());
        }
    }

    public static class Handler
    implements IMessageHandler<TeamStatsMessage, IMessage> {
        @Override
        public IMessage onMessage(TeamStatsMessage message, PacketContext ctx) {
            ctx.getTaskQueue().accept(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(TeamStatsMessage message, PacketContext ctx) {
            if (message.stats.size() == 1) {
                TeamLiteStat.updateTeam(message.stats.get(0));
            } else {
                TeamLiteStat.updateTeams(message.stats);
            }
        }
    }
}

