/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.platform;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.platform.NetworkManager;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import hardcorequesting.common.forge.util.Fraction;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;

public interface AbstractPlatform {
    public Path getConfigDir();

    public NetworkManager getNetworkManager();

    public MinecraftServer getServer();

    public String getModVersion();

    public boolean isClient();

    public void registerOnCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    public void registerOnWorldLoad(BiConsumer<ResourceKey<Level>, ServerLevel> var1);

    public void registerOnWorldSave(Consumer<ServerLevel> var1);

    public void registerOnPlayerJoin(Consumer<ServerPlayer> var1);

    public void registerOnServerTick(Consumer<MinecraftServer> var1);

    @OnlyIn(value=Dist.CLIENT)
    public void registerOnClientTick(Consumer<Minecraft> var1);

    public void registerOnWorldTick(Consumer<Level> var1);

    public void registerOnUseItem(TriConsumer<Player, Level, InteractionHand> var1);

    public void registerOnBlockPlace(BlockPlaced var1);

    public void registerOnBlockUse(BlockUsed var1);

    public void registerOnBlockBreak(BlockBroken var1);

    public void registerOnItemPickup(BiConsumer<Player, ItemStack> var1);

    public void registerOnLivingDeath(BiConsumer<LivingEntity, DamageSource> var1);

    public void registerOnCrafting(BiConsumer<Player, ItemStack> var1);

    public void registerOnAnvilCrafting(BiConsumer<Player, ItemStack> var1);

    public void registerOnSmelting(BiConsumer<Player, ItemStack> var1);

    public void registerOnAdvancement(BiConsumer<ServerPlayer, Advancement> var1);

    public void registerOnAnimalTame(BiConsumer<Player, Entity> var1);

    public CompoundTag getPlayerExtraTag(Player var1);

    public AbstractBarrelBlockEntity createBarrelBlockEntity(BlockPos var1, BlockState var2);

    public List<FluidStack> findFluidsIn(ItemStack var1);

    public Fraction getBucketAmount();

    public <T extends Block> Supplier<T> registerBlock(String var1, Supplier<T> var2);

    public Supplier<SoundEvent> registerSound(String var1, Supplier<SoundEvent> var2);

    public <T extends Item> Supplier<T> registerItem(String var1, Supplier<T> var2);

    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String var1, BiFunction<BlockPos, BlockState, T> var2, Supplier<Block> var3);

    public Supplier<RecipeSerializer<?>> registerBookRecipeSerializer(String var1);

    public Supplier<CreativeModeTab> registerTab(String var1, Supplier<CreativeModeTab> var2);

    public static interface BlockBroken {
        public void onBlockBroken(LevelAccessor var1, BlockPos var2, BlockState var3, Player var4);
    }

    public static interface BlockUsed {
        public void onBlockUsed(Player var1, Level var2, InteractionHand var3, BlockPos var4, Direction var5);
    }

    public static interface BlockPlaced {
        public void onBlockPlaced(Level var1, BlockPos var2, BlockState var3, LivingEntity var4);
    }
}

