/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.proxies;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.interfaces.graphic.task.AdvancementTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.CheckBoxTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.CompleteQuestTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.DeathTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ItemTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.KillMobsTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.KillReputationTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.LocationTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ReputationTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TameMobsTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TaskGraphics;
import hardcorequesting.common.forge.network.PacketContext;
import hardcorequesting.common.forge.proxies.CommonProxy;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestTicker;
import hardcorequesting.common.forge.quests.task.TaskType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        super.init();
        Quest.clientTicker = new QuestTicker();
        HardcoreQuestingCore.platform.registerOnClientTick(minecraftClient -> Quest.clientTicker.tick((Level)minecraftClient.f_91073_, true));
        ClientLifecycleEvent.CLIENT_SETUP.register(instance -> ClientProxy.setupTaskGraphics());
    }

    private static void setupTaskGraphics() {
        TaskGraphics.register((TaskType)TaskType.CHECKBOX.get(), CheckBoxTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.CONSUME.get(), (task, playerId, questBook) -> ItemTaskGraphic.createConsumeGraphic(task, playerId, questBook, true));
        TaskGraphics.register((TaskType)TaskType.CRAFT.get(), ItemTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.LOCATION.get(), LocationTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.CONSUME_QDS.get(), (task, playerId, questBook) -> ItemTaskGraphic.createConsumeGraphic(task, playerId, questBook, false));
        TaskGraphics.register((TaskType)TaskType.DETECT.get(), ItemTaskGraphic::createDetectGraphic);
        TaskGraphics.register((TaskType)TaskType.KILL.get(), KillMobsTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.TAME.get(), TameMobsTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.DEATH.get(), DeathTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.REPUTATION.get(), ReputationTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.REPUTATION_KILL.get(), KillReputationTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.ADVANCEMENT.get(), AdvancementTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.COMPLETION.get(), CompleteQuestTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.BLOCK_BREAK.get(), ItemTaskGraphic::new);
        TaskGraphics.register((TaskType)TaskType.BLOCK_PLACE.get(), ItemTaskGraphic::new);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public Player getPlayer(PacketContext ctx) {
        return ctx.isClient() ? Minecraft.m_91087_().f_91074_ : super.getPlayer(ctx);
    }
}

