/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.QuestDataUpdateMessage;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestSetsManager;
import hardcorequesting.common.forge.quests.QuestTicker;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.quests.TriggerType;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.reward.QuestRewards;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.WrappedText;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Quest {
    @Deprecated
    public static boolean isEditing = false;
    public static UUID speciallySelectedQuestId = null;
    public static QuestTicker clientTicker;
    public static QuestTicker serverTicker;
    private final QuestRewards rewards = new QuestRewards(this);
    private UUID questId;
    private WrappedText name;
    private WrappedText description;
    private List<UUID> requirement;
    private List<UUID> reversedRequirement;
    private List<UUID> optionLinks;
    private List<UUID> reversedOptionLinks;
    private List<QuestTask<?>> tasks;
    private RepeatInfo repeatInfo = new RepeatInfo(RepeatType.NONE, 0, 0);
    private TriggerType triggerType = TriggerType.NONE;
    private int triggerTasks = 1;
    private int parentRequirementCount = -1;
    private int x;
    private int y;
    private boolean isBig;
    private Either<ItemStack, FluidStack> iconStack = Either.left((Object)ItemStack.f_41583_);
    private QuestSet set;
    private ParentEvaluator enabledParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isCompleted(playerId);
        }
    };
    private ParentEvaluator linkParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isLinkFree(playerId, isLinkFreeCache);
        }
    };
    private ParentEvaluator visibleParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(UUID playerId, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isVisible(playerId, isVisibleCache, isLinkFreeCache) || parent.isCompleted(playerId);
        }
    };

    public Quest(WrappedText name, WrappedText description, int x, int y, boolean isBig) {
        do {
            this.questId = UUID.randomUUID();
        } while (Quest.getQuests().containsKey(this.questId));
        this.name = name;
        this.x = x;
        this.y = y;
        this.isBig = isBig;
        this.description = description;
        this.requirement = new ArrayList<UUID>();
        this.reversedRequirement = new ArrayList<UUID>();
        this.optionLinks = new ArrayList<UUID>();
        this.reversedOptionLinks = new ArrayList<UUID>();
        this.tasks = new ArrayList();
        QuestSetsManager.getInstance().quests.put(this.getQuestId(), this);
    }

    public static Map<UUID, Quest> getQuests() {
        return QuestSetsManager.getInstance().quests;
    }

    public static List<QuestSet> getQuestSets() {
        return QuestLine.getActiveQuestLine().questSetsManager.questSets;
    }

    public static String getRawMainDescription() {
        return QuestLine.getActiveQuestLine().getMainDescription();
    }

    @Nullable
    public static Quest getQuest(UUID questId) {
        if (questId == null) {
            return null;
        }
        return QuestSetsManager.getInstance().quests.get(questId);
    }

    public static void removeQuest(Quest quest) {
        for (UUID requirementId : quest.requirement) {
            Quest.getQuest((UUID)requirementId).reversedRequirement.remove(quest.getQuestId());
        }
        for (UUID optionLinkId : quest.optionLinks) {
            Quest.getQuest((UUID)optionLinkId).reversedOptionLinks.remove(quest.getQuestId());
        }
        quest.tasks.forEach(QuestTask::onDelete);
        quest.setQuestSet(null);
        QuestSetsManager.getInstance().quests.remove(quest.getQuestId());
        for (Quest other : QuestSetsManager.getInstance().quests.values()) {
            UUID element;
            Iterator<UUID> iterator = other.requirement.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getQuestId())) continue;
                iterator.remove();
            }
            iterator = other.optionLinks.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getQuestId())) continue;
                iterator.remove();
            }
        }
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public QuestRewards getRewards() {
        return this.rewards;
    }

    public boolean hasReward(UUID playerId) {
        return this.getRewards().hasReward(playerId);
    }

    public RepeatInfo getRepeatInfo() {
        return this.repeatInfo;
    }

    public void setRepeatInfo(RepeatInfo repeatInfo) {
        this.repeatInfo = repeatInfo;
    }

    public void addRequirement(UUID requirementQuestId) {
        if (requirementQuestId.equals(this.questId)) {
            return;
        }
        if (this.lookForId(requirementQuestId, false) || this.lookForId(requirementQuestId, true)) {
            return;
        }
        Quest quest = QuestSetsManager.getInstance().quests.get(requirementQuestId);
        if (quest != null) {
            this.requirement.add(quest.getQuestId());
            quest.reversedRequirement.add(this.getQuestId());
            SaveHelper.add(EditType.REQUIREMENT_CHANGE);
        }
    }

    private boolean lookForId(UUID questId, boolean reversed) {
        return this.lookForId(questId, new HashSet<UUID>(), reversed);
    }

    private boolean lookForId(UUID questId, Set<UUID> visited, boolean reversed) {
        if (visited.add(this.getQuestId())) {
            List<UUID> currentRequirements = reversed ? this.reversedRequirement : this.requirement;
            for (UUID id : currentRequirements) {
                if (!id.equals(questId) && !QuestSetsManager.getInstance().quests.get(id).lookForId(questId, visited, reversed)) continue;
                return true;
            }
        }
        return false;
    }

    public void clearRequirements() {
        SaveHelper.add(EditType.REQUIREMENT_REMOVE, this.requirement.size());
        for (UUID questId : this.requirement) {
            QuestSetsManager.getInstance().quests.get((Object)questId).reversedRequirement.remove(this.getQuestId());
        }
        this.requirement.clear();
    }

    public void addOptionLink(UUID optionLinkId) {
        if (optionLinkId.equals(this.questId)) {
            return;
        }
        for (UUID currentOptionId : this.optionLinks) {
            if (!currentOptionId.equals(optionLinkId)) continue;
            return;
        }
        for (UUID currentReverseOptionsId : this.reversedOptionLinks) {
            if (!currentReverseOptionsId.equals(optionLinkId)) continue;
            return;
        }
        Quest quest = QuestSetsManager.getInstance().quests.get(optionLinkId);
        if (quest != null) {
            SaveHelper.add(EditType.OPTION_CHANGE);
            this.optionLinks.add(quest.getQuestId());
            quest.reversedOptionLinks.add(this.getQuestId());
        }
    }

    public void clearOptionLinks() {
        SaveHelper.add(EditType.OPTION_REMOVE, this.optionLinks.size());
        for (UUID questId : this.reversedOptionLinks) {
            QuestSetsManager.getInstance().quests.get((Object)questId).optionLinks.remove(this.getQuestId());
        }
        for (UUID questId : this.optionLinks) {
            QuestSetsManager.getInstance().quests.get((Object)questId).reversedOptionLinks.remove(this.getQuestId());
        }
        this.reversedRequirement.clear();
        this.optionLinks.clear();
    }

    public QuestData getQuestData(Player player) {
        return QuestingDataManager.getInstance().getQuestingData(player).getQuestData(this.getQuestId());
    }

    public QuestData getQuestData(UUID uuid) {
        return QuestingDataManager.getInstance().getQuestingData(uuid).getQuestData(this.getQuestId());
    }

    public void setQuestData(Player player, QuestData data) {
        QuestingDataManager.getInstance().getQuestingData(player).setQuestData(this.getQuestId(), data);
    }

    public UUID getQuestId() {
        return this.questId;
    }

    public void setId(UUID questId) {
        if (this.getQuestSet() != null) {
            this.getQuestSet().removeQuest(this);
        }
        Quest.getQuests().remove(this.getQuestId());
        this.questId = questId;
        Quest.getQuests().put(this.getQuestId(), this);
        if (this.getQuestSet() != null) {
            this.getQuestSet().addQuest(this);
        }
    }

    public MutableComponent getName() {
        return this.name.getText();
    }

    public WrappedText getRawName() {
        return this.name;
    }

    public void setName(WrappedText name) {
        this.name = name;
    }

    public boolean isVisible(Player player) {
        return this.isVisible(player.m_20148_());
    }

    public boolean isVisible(Player player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isVisible(player.m_20148_(), isVisibleCache, isLinkFreeCache);
    }

    public boolean isVisible(UUID uuid) {
        return this.isVisible(uuid, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isVisible(UUID playerId, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        Boolean cachedResult = isVisibleCache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.triggerType.isQuestVisible(this, playerId) && this.isLinkFree(playerId, isLinkFreeCache) && this.visibleParentEvaluator.isValid(playerId, isVisibleCache, isLinkFreeCache);
        isVisibleCache.put(this, result);
        return result;
    }

    public boolean isEnabled(Player player) {
        return this.isEnabled(player.m_20148_());
    }

    public boolean isEnabled(Player player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isEnabled(player.m_20148_(), true, isVisibleCache, isLinkFreeCache);
    }

    public boolean isEnabled(UUID playerId) {
        return this.isEnabled(playerId, true);
    }

    public boolean isEnabled(UUID playerId, boolean requiresVisible) {
        return this.isEnabled(playerId, requiresVisible, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isEnabled(UUID playerId, boolean requiresVisible, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.set != null && this.isLinkFree(playerId, isLinkFreeCache) && (!requiresVisible || this.triggerType.doesWorkAsInvisible() || this.isVisible(playerId, isVisibleCache, isLinkFreeCache)) && this.enabledParentEvaluator.isValid(playerId, isVisibleCache, isLinkFreeCache);
    }

    public boolean isLinkFree(Player player) {
        return this.isLinkFree(player.m_20148_(), new HashMap<Quest, Boolean>());
    }

    public boolean isLinkFree(Player player, Map<Quest, Boolean> cache) {
        return this.isLinkFree(player.m_20148_(), cache);
    }

    public boolean isLinkFree(UUID uuid) {
        return this.isLinkFree(uuid, new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(UUID playerId, Map<Quest, Boolean> cache) {
        Boolean cachedResult = cache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = true;
        for (UUID optionLinkId : this.optionLinks) {
            if (!QuestSetsManager.getInstance().quests.get(optionLinkId).isCompleted(playerId)) continue;
            result = false;
            break;
        }
        if (result) {
            for (UUID optionLinkId : this.reversedOptionLinks) {
                if (!QuestSetsManager.getInstance().quests.get(optionLinkId).isCompleted(playerId)) continue;
                result = false;
                break;
            }
        }
        if (result) {
            result = this.linkParentEvaluator.isValid(playerId, null, cache);
        }
        cache.put(this, result);
        return result;
    }

    public boolean isAvailable(Player player) {
        return this.isAvailable(player.m_20148_());
    }

    public boolean isCompleted(Player player) {
        return this.isCompleted(player.m_20148_());
    }

    public boolean isAvailable(UUID playerId) {
        QuestData data = this.getQuestData(playerId);
        return data != null && data.available;
    }

    public boolean isCompleted(UUID uuid) {
        QuestData data = this.getQuestData(uuid);
        return data != null && data.completed;
    }

    public List<Quest> getRequirements() {
        return this.requirement.stream().map(QuestSetsManager.getInstance().quests::get).collect(Collectors.toList());
    }

    public int getGuiX() {
        return this.x;
    }

    public int getGuiY() {
        return this.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getGuiU() {
        return this.isBig ? 195 : 170;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getGuiV(Player player, int x, int y) {
        return this.isEnabled(player) && this.isMouseInObject(x, y) ? this.getGuiH() : 0;
    }

    public int getGuiW() {
        return this.isBig ? 31 : 25;
    }

    public int getGuiH() {
        return this.isBig ? 37 : 30;
    }

    public int getGuiCenterX() {
        return this.getGuiX() + this.getGuiW() / 2;
    }

    public void setGuiCenterX(int x) {
        this.x = x - this.getGuiW() / 2;
    }

    public int getGuiCenterY() {
        return this.getGuiY() + this.getGuiH() / 2;
    }

    public void setGuiCenterY(int y) {
        this.y = y - this.getGuiH() / 2;
    }

    public Either<ItemStack, FluidStack> getIconStack() {
        return this.iconStack;
    }

    public void setIconStack(Either<ItemStack, FluidStack> iconStack) {
        this.iconStack = iconStack;
    }

    public void setIconIfEmpty(ItemStack stack) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            this.setIconIfEmpty((Either<ItemStack, FluidStack>)Either.left((Object)stack));
        }
    }

    public void setIconIfEmpty(FluidStack stack) {
        if (!stack.isEmpty()) {
            this.setIconIfEmpty((Either<ItemStack, FluidStack>)Either.right((Object)stack));
        }
    }

    public void setIconIfEmpty(Either<ItemStack, FluidStack> iconStack) {
        if (((Boolean)this.iconStack.map(ItemStack::m_41619_, FluidStack::isEmpty)).booleanValue()) {
            this.setIconStack(iconStack);
            SaveHelper.add(EditType.ICON_CHANGE);
        }
    }

    public boolean useBigIcon() {
        return this.isBig;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public int getTriggerTasks() {
        return this.triggerTasks;
    }

    public void setTriggerTasks(int triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFilter(Player player, int tick) {
        boolean hasReward = this.hasReward(player.m_20148_());
        if (Quest.canQuestsBeEdited() && !this.isVisible(player)) {
            return HQMConfig.QUEST_INVISIBLE;
        }
        if (!this.isEnabled(player)) {
            return HQMConfig.QUEST_DISABLED;
        }
        if (!this.isAvailable(player) && !hasReward) {
            return this.getRepeatInfo().getType() == RepeatType.NONE ? HQMConfig.QUEST_COMPLETE : HQMConfig.QUEST_COMPLETE_REPEATABLE;
        }
        if (HQMConfig.getInstance().Interface.Quests.SINGLE_COLOUR) {
            return HQMConfig.QUEST_AVAILABLE;
        }
        int componentBase = 187;
        int componentVariable = (int)(Math.abs(Math.sin((float)tick / 5.0f)) * 68.0);
        int component = componentBase + componentVariable;
        int red = hasReward ? componentBase : component;
        int green = hasReward ? component * 3 / 4 : component;
        int blue = component;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isMouseInObject(int x, int y) {
        if (this.getGuiX() > x || x > this.getGuiX() + this.getGuiW() || this.getGuiY() > y || y > this.getGuiY() + this.getGuiH()) {
            return false;
        }
        Polygon poly = new Polygon();
        if (this.isBig) {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 1);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 36);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 27);
        } else {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 2);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 21);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 21);
        }
        return poly.contains(x, y);
    }

    public QuestData createData(int players) {
        QuestData data = new QuestData(players);
        data.verifyTasksSize(this);
        return data;
    }

    public List<QuestTask<?>> getTasks() {
        return this.tasks;
    }

    public void removeTask(QuestTask<?> task) {
        int index = this.tasks.indexOf(task);
        task.onDelete();
        this.tasks.remove(index);
        int nextTaskId = 0;
        for (QuestTask<?> questTask : this.tasks) {
            questTask.updateId(nextTaskId++);
        }
        for (Team team : TeamManager.getInstance().getTeams()) {
            team.getQuestData(this.getQuestId()).clearTaskData(this);
        }
    }

    public void sendUpdatedDataToTeam(Player player) {
        this.sendUpdatedDataToTeam(QuestingDataManager.getInstance().getQuestingData(player).getTeam());
    }

    public void sendUpdatedDataToTeam(UUID playerId) {
        this.sendUpdatedDataToTeam(QuestingDataManager.getInstance().getQuestingData(playerId).getTeam());
    }

    public void sendUpdatedDataToTeam(Team team) {
        MinecraftServer server = HardcoreQuestingCore.getServer();
        if (server == null || !server.m_18695_()) {
            throw new IllegalStateException("Tried sending data to players from the client-side. Something is being called client-side when it shouldn't be!");
        }
        for (PlayerEntry entry : team.getPlayers()) {
            this.sendUpdatedData(entry.getPlayerMP());
        }
    }

    public void sendUpdatedData(ServerPlayer player) {
        if (player == null) {
            return;
        }
        QuestDataUpdateMessage update = new QuestDataUpdateMessage(this.getQuestId(), QuestingDataManager.getInstance().getQuestingData((Player)player).getTeam().getPlayerCount(), QuestingDataManager.getInstance().getQuestingData((Player)player).getQuestData(this.getQuestId()));
        NetworkManager.sendToPlayer(update, player);
    }

    public void setBigIcon(boolean b) {
        this.isBig = b;
    }

    public WrappedText getDescription() {
        return this.description;
    }

    public void setDescription(WrappedText description) {
        this.description = description;
    }

    public boolean hasSameSetAs(Quest child) {
        return child.set.equals(this.set);
    }

    public boolean hasSet(QuestSet selectedSet) {
        return this.set != null && this.set.equals(selectedSet);
    }

    public void mergeProgress(UUID playerId, QuestData own, QuestData other) {
        if (other.completed) {
            own.completed = true;
            if (other.available && !own.teamRewardClaimed) {
                own.available = true;
            }
        }
        for (QuestTask<?> task : this.tasks) {
            task.mergeProgress(playerId, own, other);
        }
    }

    public void copyProgress(QuestData own, QuestData other) {
        own.completed = other.completed;
        own.available = other.available;
        for (QuestTask<?> task : this.tasks) {
            task.copyProgress(own, other);
        }
    }

    public void completeQuest(Player player) {
        for (QuestTask<?> task : this.tasks) {
            task.completeTask(player.m_20148_());
        }
        QuestTask.completeQuest(this, player.m_20148_());
    }

    public void reset(UUID playerId) {
        this.reset(this.getQuestData(playerId));
    }

    public void reset(QuestData data) {
        data.available = true;
        data.clearTaskData(this);
    }

    public void resetAll() {
        for (Team team : TeamManager.getInstance().getTeams()) {
            QuestData data = team.getQuestData(this.getQuestId());
            if (data == null || data.available) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public void resetOnTime(long time) {
        for (Team team : TeamManager.getInstance().getTeams()) {
            QuestData data = team.getQuestData(this.getQuestId());
            if (data == null || data.available || data.time > time) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public float getProgress(Team team) {
        float data = 0.0f;
        for (QuestTask<?> task : this.tasks) {
            data += task.getCompletedRatio(team);
        }
        return data / (float)this.tasks.size();
    }

    public List<Quest> getOptionLinks() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.optionLinks.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public List<Quest> getReversedOptionLinks() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.reversedOptionLinks.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public boolean getUseModifiedParentRequirement() {
        return this.parentRequirementCount != -1;
    }

    public int getParentRequirementCount() {
        return this.parentRequirementCount == -1 ? this.getRequirements().size() : this.parentRequirementCount;
    }

    public int _getParentRequirementCount() {
        return this.parentRequirementCount;
    }

    public void setParentRequirementCount(int parentRequirementCount) {
        this.parentRequirementCount = parentRequirementCount;
    }

    public QuestSet getQuestSet() {
        return this.set;
    }

    public void setQuestSet(QuestSet set) {
        if (this.set != null) {
            this.set.removeQuest(this);
        }
        this.set = set;
        if (this.set != null) {
            this.set.addQuest(this);
        }
    }

    public List<Quest> getReversedRequirement() {
        return QuestSetsManager.getInstance().quests.values().stream().filter(quest -> this.reversedRequirement.contains(quest.getQuestId())).collect(Collectors.toList());
    }

    public static boolean canQuestsBeEdited() {
        if (isEditing && !HQMUtil.isSinglePlayerOnly()) {
            Quest.setEditMode(false);
        }
        return isEditing;
    }

    public static void setEditMode(boolean enabled) {
        isEditing = enabled;
    }

    private abstract class ParentEvaluator {
        private ParentEvaluator() {
        }

        protected abstract boolean isValid(UUID var1, Quest var2, Map<Quest, Boolean> var3, Map<Quest, Boolean> var4);

        private boolean isValid(UUID uuid, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            int parents = Quest.this.getRequirements().size();
            int requiredAmount = Quest.this.getParentRequirementCount();
            if (requiredAmount > parents) {
                return false;
            }
            int allowedUncompleted = parents - requiredAmount;
            int uncompleted = 0;
            for (Quest quest : Quest.this.getRequirements()) {
                if (this.isValid(uuid, quest, isVisibleCache, isLinkFreeCache) || ++uncompleted <= allowedUncompleted) continue;
                return false;
            }
            return true;
        }
    }
}

