/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Lists;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestSetsGraphic;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.io.DataReader;
import hardcorequesting.common.forge.io.DataWriter;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.network.message.PlayerDataSyncMessage;
import hardcorequesting.common.forge.network.message.TeamStatsMessage;
import hardcorequesting.common.forge.quests.QuestSetsManager;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.Serializable;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class QuestLine {
    private static QuestLine activeQuestLine;
    public final ReputationManager reputationManager;
    public final GroupTierManager groupTierManager;
    public final QuestingDataManager questingDataManager;
    public final DeathStatsManager deathStatsManager;
    public final QuestSetsManager questSetsManager;
    public final TeamManager teamManager;
    public final Serializable descriptionManager;
    private String mainDescription = "No description";
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation front;
    private final List<Serializable> questSerializables = Lists.newArrayList();
    private final List<Serializable> dataSerializables = Lists.newArrayList();

    private QuestLine() {
        this.reputationManager = new ReputationManager();
        this.groupTierManager = new GroupTierManager();
        this.questingDataManager = new QuestingDataManager();
        this.deathStatsManager = new DeathStatsManager();
        this.questSetsManager = new QuestSetsManager();
        this.teamManager = new TeamManager();
        this.descriptionManager = new SimpleSerializable(){

            @Override
            public String filePath() {
                return "description.txt";
            }

            @Override
            public String saveToString() {
                return QuestLine.this.getMainDescription();
            }

            @Override
            public void clear() {
                QuestLine.this.setMainDescription("No description");
            }

            @Override
            public void loadFromString(String string) {
                QuestLine.this.setMainDescription(string);
            }

            @Override
            public boolean isData() {
                return false;
            }
        };
        GroupTier.initBaseTiers(this);
        this.add(this.descriptionManager);
        this.add(this.questingDataManager.state);
        this.add(this.deathStatsManager);
        this.add(this.reputationManager);
        this.add(this.groupTierManager);
        this.add(this.questSetsManager);
        this.add(this.teamManager);
        this.add(this.questingDataManager.data);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void resetClient() {
        GuiQuestBook.resetBookPosition();
        QuestSetsGraphic.loginReset();
    }

    public void add(Serializable serializable) {
        if (serializable.isData()) {
            this.dataSerializables.add(serializable);
        } else {
            this.questSerializables.add(serializable);
        }
    }

    public static QuestLine getActiveQuestLine() {
        return activeQuestLine;
    }

    public static QuestLine reset() {
        SaveHelper.onLoad();
        if (HardcoreQuestingCore.platform.isClient()) {
            QuestLine.resetClient();
        }
        activeQuestLine = new QuestLine();
        return activeQuestLine;
    }

    public static void sendDataToClient(ServerPlayer player) {
        QuestLine questLine = QuestLine.getActiveQuestLine();
        if (!player.f_8924_.m_7779_(player.m_36316_())) {
            boolean side = !HardcoreQuestingCore.platform.isClient();
            NetworkManager.sendToPlayer(new PlayerDataSyncMessage(questLine, (Player)player), player);
            NetworkManager.sendToPlayer(new DeathStatsMessage(side), player);
        }
        NetworkManager.sendToPlayer(new TeamStatsMessage(StreamSupport.stream(questLine.teamManager.getNamedTeams().spliterator(), false)), player);
    }

    public String getMainDescription() {
        return this.mainDescription;
    }

    public void setMainDescription(String mainDescription) {
        this.mainDescription = mainDescription;
    }

    public void saveQuests(@NotNull DataWriter cfqWriter) {
        for (Serializable serializable : this.questSerializables) {
            serializable.save(cfqWriter);
        }
    }

    public void saveData(@NotNull DataWriter dataWriter) {
        for (Serializable serializable : this.dataSerializables) {
            serializable.save(dataWriter);
        }
    }

    public void loadAll(DataReader cfgReader, DataReader dataReader) {
        HardcoreQuestingCore.LOGGER.info("[HQM] Loading Quest Line, with data: %s", (Object)cfgReader);
        for (Serializable serializable : this.questSerializables) {
            serializable.load(cfgReader);
        }
        for (Serializable serializable : this.dataSerializables) {
            serializable.load(dataReader);
        }
    }
}

