/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestSet {
    private String name;
    private WrappedText description;
    private List<FormattedText> cachedDescription;
    private Map<UUID, Quest> quests = new ConcurrentHashMap<UUID, Quest>();
    private List<ReputationBar> reputationBars;
    private int id;
    private static List<String> FORBIDDEN_SET_NAMES = Arrays.asList("sets", "reputations", "bags", "con", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "com0", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "lpt0");
    private static List<String> FORBIDDEN_SET_NAME_PIECES = Arrays.asList("<", ">", ":", "\"", "\\", "/", "|", "?", "*");

    public QuestSet(String name, WrappedText description) {
        this.name = name;
        this.description = description;
        this.reputationBars = new ArrayList<ReputationBar>();
        this.id = Quest.getQuestSets().size();
    }

    public Map<UUID, Quest> getQuests() {
        return this.quests;
    }

    public List<ReputationBar> getReputationBars() {
        this.validateBars();
        return this.reputationBars;
    }

    private void validateBars() {
        ArrayList<ReputationBar> toRemove = new ArrayList<ReputationBar>();
        for (ReputationBar reputationBar : this.reputationBars) {
            if (reputationBar.isValid()) continue;
            toRemove.add(reputationBar);
        }
        this.reputationBars.removeAll(toRemove);
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String name) {
        String test_name = name.toLowerCase().trim();
        if (FORBIDDEN_SET_NAMES.contains(test_name)) {
            return false;
        }
        for (String piece : FORBIDDEN_SET_NAME_PIECES) {
            if (!test_name.contains(piece)) continue;
            return false;
        }
        int inc = 1;
        String new_name = name;
        List names = Quest.getQuestSets().stream().filter(q -> q != this).map(q -> q.getName().toLowerCase()).collect(Collectors.toList());
        while (names.contains(new_name.toLowerCase())) {
            new_name = String.format("%s%d", name, inc++);
            if (inc < 20) continue;
            return false;
        }
        this.name = new_name;
        return true;
    }

    public String getFilename() {
        return this.name.replaceAll(" ", "_");
    }

    public String getName(int i) {
        return i + 1 + ". " + this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<FormattedText> getDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText((FormattedText)this.getDescription(), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public boolean isEnabled(Player player) {
        return this.isEnabled(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    public boolean isEnabled(Player player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted(Player player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (quest.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest.getQuestId());
    }

    public void addQuest(Quest quest) {
        this.quests.put(quest.getQuestId(), quest);
    }

    public void removeRepBar(ReputationBar repBar) {
        this.reputationBars.remove(repBar);
    }

    public void addRepBar(ReputationBar repBar) {
        if (repBar == null) {
            return;
        }
        this.reputationBars.add(repBar);
    }

    public int getCompletedCount(Player player) {
        return this.getCompletedCount(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    public int getCompletedCount(Player player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        int count = 0;
        for (Quest quest : this.quests.values()) {
            if (!quest.isCompleted(player) || !quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++count;
        }
        return count;
    }

    public MutableComponent getDescription() {
        return this.description.getText();
    }

    public WrappedText getRawDescription() {
        return this.description;
    }

    public void setDescription(WrappedText description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public int getId() {
        return this.id;
    }

    public void decreaseId() {
        --this.id;
    }
}

