/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.DataReader;
import hardcorequesting.common.forge.io.DataWriter;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.io.adapter.QuestAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.Serializable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class QuestSetsManager
implements Serializable {
    private static final Pattern JSON = Pattern.compile(".*\\.json$", 2);
    private static final Pattern BAGS = Pattern.compile("^bags\\.json$", 2);
    private static final Pattern DEATHS = Pattern.compile("^deaths\\.json$", 2);
    private static final Pattern REPUTATIONS = Pattern.compile("^reputations\\.json$", 2);
    private static final Pattern TEAMS = Pattern.compile("^teams\\.json$", 2);
    private static final Pattern STATE = Pattern.compile("^state\\.json$", 2);
    private static final Pattern DATA = Pattern.compile("^data\\.json$", 2);
    private static final Pattern SETS = Pattern.compile("^sets\\.json$", 2);
    private static final DirectoryStream.Filter<Path> QUEST_SET_FILTER = path -> {
        String name = path.getFileName().toString();
        return JSON.matcher(name).find() && !REPUTATIONS.matcher(name).find() && !BAGS.matcher(name).find() && !TEAMS.matcher(name).find() && !STATE.matcher(name).find() && !DATA.matcher(name).find() && !SETS.matcher(name).find() && !DEATHS.matcher(name).find();
    };
    public final Map<UUID, Quest> quests = new ConcurrentHashMap<UUID, Quest>();
    public final List<QuestSet> questSets = Lists.newArrayList();

    public static QuestSetsManager getInstance() {
        return QuestLine.getActiveQuestLine().questSetsManager;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public void save(DataWriter writer) {
        JsonObject object = new JsonObject();
        JsonArray array = new JsonArray();
        this.questSets.stream().map(QuestSet::getFilename).distinct().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        object.add("sets", (JsonElement)array);
        writer.write("sets.json", object.toString());
        for (QuestSet set : this.questSets) {
            writer.write("sets/" + set.getFilename() + ".json", SaveHandler.save(set, QuestSet.class));
        }
    }

    @Override
    public void load(DataReader reader) {
        this.quests.clear();
        this.questSets.clear();
        EventTrigger.instance().clear();
        reader.read("sets.json").map(arg_0 -> ((JsonParser)SaveHandler.JSON_PARSER).parse(arg_0)).ifPresent(jsonElement -> {
            if (jsonElement.isJsonArray()) {
                this.loadSetsFromJsonOld(reader, jsonElement.getAsJsonArray());
            } else {
                this.loadSetsFromJson(reader, (JsonElement)jsonElement);
            }
        });
        try {
            QuestAdapter.postLoad();
        }
        catch (IOException e) {
            HardcoreQuestingCore.LOGGER.warn("Failed loading quest sets for remote", (Throwable)e);
        }
        HardcoreQuestingCore.LOGGER.info("Loaded %d quests from %d quest sets.", (Object)this.quests.size(), (Object)this.questSets.size());
    }

    private void loadSetsFromJson(DataReader reader, JsonElement jsonElement) {
        ArrayList sets = Lists.newArrayList();
        for (JsonElement element : jsonElement.getAsJsonObject().get("sets").getAsJsonArray()) {
            sets.add(element.getAsString());
        }
        for (String set : sets) {
            reader.read("sets/" + set + ".json").flatMap(setText -> SaveHandler.load(setText, QuestSet.class)).filter(Predicates.not(this.questSets::contains)).ifPresent(this.questSets::add);
        }
    }

    private void loadSetsFromJsonOld(DataReader reader, JsonArray jsonArray) {
        ArrayList order = Lists.newArrayList();
        for (JsonElement element : jsonArray) {
            order.add(element.getAsString());
        }
        reader.readAll(QUEST_SET_FILTER).flatMap(setText -> SaveHandler.load(setText, QuestSet.class).stream()).filter(Predicates.not(this.questSets::contains)).forEach(this.questSets::add);
        this.questSets.sort((s1, s2) -> {
            if (s1.equals(s2)) {
                return 0;
            }
            int is1 = order.indexOf(s1.getName());
            int is2 = order.indexOf(s2.getName());
            if (is1 == -1) {
                return is2 == -1 ? s1.getName().compareTo(s2.getName()) : 1;
            }
            if (is2 == -1) {
                return -1;
            }
            if (is1 == is2) {
                return 0;
            }
            return is1 < is2 ? -1 : 1;
        });
    }
}

