/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Iterables;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.GroupData;
import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.LivesUpdate;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.team.TeamUpdateSize;
import hardcorequesting.common.forge.util.Translator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestingData {
    public UUID selectedQuestId = null;
    public int selectedTask = -1;
    public boolean playedLore;
    public boolean receivedBook;
    private Team team;
    private int lives;
    private UUID playerId;
    private String name;
    private Map<UUID, GroupData> groupData;

    public QuestingData(QuestingDataManager manager, UUID playerId) {
        this.lives = manager.getDefaultLives();
        this.playerId = playerId;
        this.team = Team.single(playerId);
        this.createGroupData();
    }

    public QuestingData(QuestingDataManager manager, UUID playerId, int lives, Map<UUID, GroupData> groupData) {
        this.playerId = playerId;
        this.lives = lives;
        this.team = TeamManager.getInstance().getByPlayer(playerId);
        this.createGroupData();
        this.groupData.putAll(groupData);
        manager.questingData.put(playerId, this);
    }

    public static Player getPlayerFromUsername(String playerName) {
        return HardcoreQuestingCore.getServer().m_6846_().m_11255_(playerName);
    }

    public static Player getPlayer(String uuid) {
        if (uuid.split("-").length == 5) {
            return QuestingData.getPlayer(UUID.fromString(uuid));
        }
        return QuestingData.getPlayerFromUsername(uuid);
    }

    public static Player getPlayer(UUID uuid) {
        MinecraftServer server = HardcoreQuestingCore.getServer();
        return server == null ? null : server.m_6846_().m_11259_(uuid);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getName() throws IllegalArgumentException {
        if (this.name == null) {
            Player player = QuestingData.getPlayer(this.playerId);
            this.name = player != null ? player.m_6302_() : "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void createGroupData() {
        this.groupData = new HashMap<UUID, GroupData>();
        LootGroup.getGroups().keySet().forEach(this::createGroupData);
    }

    private void createGroupData(UUID groupId) {
        this.groupData.put(groupId, new GroupData());
    }

    public int getLives() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getSharedLives() : this.getRawLives();
    }

    public int getLivesToStayAlive() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getPlayerCount() : 1;
    }

    public int getRawLives() {
        return this.lives;
    }

    public void setRawLives(int lives) {
        this.lives = lives;
    }

    public QuestData getQuestData(UUID questId) {
        return this.getTeam().getQuestData(questId);
    }

    public void setQuestData(UUID questId, QuestData data) {
        this.getTeam().setQuestData(questId, data);
    }

    public GroupData getGroupData(UUID groupId) {
        if (!this.groupData.containsKey(groupId)) {
            this.createGroupData(groupId);
        }
        return this.groupData.get(groupId);
    }

    public int addLives(Player player, int amount) {
        int max = HQMConfig.getInstance().Hardcore.MAX_LIVES;
        int i = this.getRawLives() + amount;
        this.lives = Math.min(i, max);
        this.getTeam().refreshTeamLives();
        return this.lives;
    }

    public void removeLifeAndSendMessage(@NotNull Player player) {
        boolean isDead;
        boolean bl = isDead = !this.removeLives(player, 1);
        if (!isDead) {
            player.m_213846_((Component)Translator.translatable("hqm.message.lostLife", Translator.lives(this.getLives())));
        }
        if (this.getTeam().isSharingLives()) {
            for (PlayerEntry entry : this.getTeam().getPlayers()) {
                Player other;
                if (!entry.isInTeam() || entry.getUUID().equals(player.m_20148_()) || (other = QuestingData.getPlayer(entry.getUUID())) == null) continue;
                String key = isDead ? "hqm.message.lostTeamLifeAndBan" : "hqm.message.lostTeamLife";
                other.m_213846_((Component)Translator.translatable(key, player.m_6302_(), Translator.lives(this.getLives())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLives(@NotNull Player player, int amount) {
        QuestingDataManager manager = QuestingDataManager.getInstance();
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            int dif = Math.min(this.lives - 1, amount);
            amount -= dif;
            this.lives -= dif;
            block4: while (amount > 0) {
                int players = 0;
                for (PlayerEntry entry : manager.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(player.m_20148_()) || manager.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    ++players;
                }
                if (players == 0) break;
                int id = (int)(Math.random() * (double)players);
                for (PlayerEntry entry : manager.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(player.m_20148_()) || manager.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    if (id == 0) {
                        --manager.getQuestingData((UUID)entry.getUUID()).lives;
                        --amount;
                        continue block4;
                    }
                    --id;
                }
            }
            this.lives -= amount;
        } else {
            this.lives = this.getRawLives() - amount;
        }
        if (player instanceof ServerPlayer) {
            NetworkManager.sendToPlayer(new LivesUpdate(this.playerId, this.lives), (ServerPlayer)player);
        }
        this.getTeam().refreshTeamLives();
        try {
            boolean bl;
            if (this.getLives() < this.getLivesToStayAlive()) {
                this.outOfLives(player);
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            TeamLiteStat.refreshTeam(this.team);
        }
    }

    public void die(@NotNull Player player) {
        if (QuestingDataManager.getInstance().isHardcoreActive()) {
            this.removeLifeAndSendMessage(player);
        }
    }

    private void outOfLives(Player player) {
        QuestingDataManager manager = QuestingDataManager.getInstance();
        QuestingData data = manager.getQuestingData(player);
        Team team = data.getTeam();
        if (!team.isSingle() && !Iterables.isEmpty(TeamManager.getInstance().getNamedTeams())) {
            team.removePlayer(player);
            if (team.getPlayerCount() == 0) {
                team.deleteTeam();
            } else {
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
        player.m_150109_().m_6211_();
        MinecraftServer mcServer = player.m_20194_();
        if (mcServer.m_129792_()) {
            player.m_5661_((Component)Component.m_237115_((String)"hqm.message.singlePlayerHardcore"), true);
        } else {
            String setBanReason = "Out of lives in Hardcore Questing mode";
            String setBannedBy = "HQM";
            UserBanListEntry entry = new UserBanListEntry(player.m_36316_(), null, setBannedBy, null, setBanReason);
            mcServer.m_6846_().m_11295_().m_11381_((StoredUserEntry)entry);
            ((ServerPlayer)player).f_8906_.m_9942_((Component)Translator.translatable("hqm.message.gameOver", new Object[0]));
            SoundHandler.playToAll(Sounds.DEATH);
        }
    }

    @NotNull
    public Team getTeam() {
        Team t;
        if (!this.team.isSingle() && (t = TeamManager.getInstance().getByTeamId(this.team.getId())) != null) {
            this.team = t;
        }
        return Objects.requireNonNull(this.team);
    }

    public void setTeam(@Nullable Team team) {
        if (team == null) {
            this.team = Team.single(this.playerId);
        } else if (team.isSingle()) {
            this.team = team;
        } else {
            Team t = TeamManager.getInstance().getByTeamId(team.getId());
            if (t != null) {
                this.team = t;
            } else {
                this.setTeam(null);
            }
        }
    }

    public Map<UUID, GroupData> getGroupData() {
        return this.groupData;
    }
}

