/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.team.TeamManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class QuestingDataManager {
    public static final String STATE_FILE_PATH = "state.json";
    public static final String DATA_FILE_PATH = "data.json";
    public final State state;
    public final Data data;
    private boolean hardcoreActive;
    private boolean questActive;
    public Map<UUID, QuestingData> questingData = new ConcurrentHashMap<UUID, QuestingData>();

    public QuestingDataManager() {
        this.state = new State();
        this.data = new Data();
    }

    public static QuestingDataManager getInstance() {
        return QuestLine.getActiveQuestLine().questingDataManager;
    }

    public QuestingData getQuestingData(Player player) {
        return this.getQuestingData(player.m_20148_());
    }

    public QuestingData getQuestingData(UUID playerUuid) {
        return this.questingData.computeIfAbsent(playerUuid, u -> new QuestingData(this, (UUID)u));
    }

    public Map<UUID, QuestingData> getQuestingData() {
        return this.questingData;
    }

    public boolean isHardcoreActive() {
        return this.hardcoreActive;
    }

    public boolean isQuestActive() {
        return this.questActive;
    }

    public int getDefaultLives() {
        HQMConfig instance = HQMConfig.getInstance();
        return Math.min(instance.Hardcore.MAX_LIVES, instance.Hardcore.DEFAULT_LIVES);
    }

    public void activateHardcore() {
        MinecraftServer server = HardcoreQuestingCore.getServer();
        if (server != null && !this.hardcoreActive && !server.m_7035_()) {
            this.hardcoreActive = true;
        }
    }

    public void disableHardcore() {
        this.hardcoreActive = false;
    }

    public void activateQuest(boolean giveBooks) {
        if (!this.questActive) {
            this.questActive = true;
            if (giveBooks) {
                for (Player player : HardcoreQuestingCore.getServer().m_6846_().m_11314_()) {
                    if (player == null) continue;
                    this.spawnBook(player);
                }
            }
        }
    }

    public void deactivate() {
        if (this.hardcoreActive || this.questActive) {
            this.hardcoreActive = false;
            this.questActive = false;
            this.questingData = new HashMap<UUID, QuestingData>();
        }
    }

    public static String saveQuestingState(boolean questing, boolean hardcore) {
        JsonObject object = new JsonObject();
        object.addProperty("questing", Boolean.valueOf(questing));
        object.addProperty("hardcore", Boolean.valueOf(hardcore));
        return object.toString();
    }

    public void spawnBook(Player player) {
        if (!player.m_9236_().f_46443_ && HQMConfig.getInstance().SPAWN_BOOK && !this.getQuestingData((Player)player).receivedBook && this.isQuestActive()) {
            this.getQuestingData((Player)player).receivedBook = true;
            CompoundTag hqmTag = new CompoundTag();
            CompoundTag extraTag = HardcoreQuestingCore.platform.getPlayerExtraTag(player);
            if (extraTag.m_128441_("HardcoreQuesting")) {
                hqmTag = extraTag.m_128469_("HardcoreQuesting");
            }
            hqmTag.m_128379_("questBook", true);
            extraTag.m_128365_("HardcoreQuesting", (Tag)hqmTag);
            ItemStack stack = new ItemStack((ItemLike)ModItems.book.get());
            if (!player.m_150109_().m_36054_(stack)) {
                QuestingDataManager.spawnItemAtPlayer(player, stack);
            }
        }
    }

    private static void spawnItemAtPlayer(Player player, ItemStack stack) {
        ItemEntity item = new ItemEntity(player.m_9236_(), player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, stack);
        player.m_9236_().m_7967_((Entity)item);
        item.m_6123_(player);
    }

    public void remove(Player player) {
        this.questingData.remove(player.m_20148_());
    }

    public boolean hasData(Player player) {
        return this.questingData.containsKey(player.m_36316_().getId());
    }

    public boolean hasData(UUID uuid) {
        return this.questingData.containsKey(uuid);
    }

    public class State
    extends SimpleSerializable {
        @Override
        public String saveToString() {
            return QuestingDataManager.saveQuestingState(QuestingDataManager.this.isQuestActive(), QuestingDataManager.this.isHardcoreActive());
        }

        @Override
        public String filePath() {
            return QuestingDataManager.STATE_FILE_PATH;
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public void clear() {
            boolean autoQuesting = HQMConfig.getInstance().Starting.AUTO_QUESTING;
            boolean autoHardcore = HQMConfig.getInstance().Starting.AUTO_HARDCORE;
            if (autoQuesting) {
                QuestingDataManager.this.activateQuest(false);
            }
            if (autoHardcore) {
                QuestingDataManager.this.activateHardcore();
            }
        }

        @Override
        public void loadFromString(String string) {
            boolean autoQuesting = HQMConfig.getInstance().Starting.AUTO_QUESTING;
            boolean autoHardcore = HQMConfig.getInstance().Starting.AUTO_HARDCORE;
            JsonObject object = new JsonParser().parse((Reader)new StringReader(string)).getAsJsonObject();
            QuestingDataManager.this.deactivate();
            TeamManager.getInstance().deactivate();
            if (object.get("questing").getAsBoolean() || autoQuesting) {
                QuestingDataManager.this.activateQuest(false);
            }
            if (object.get("hardcore").getAsBoolean() || autoHardcore) {
                QuestingDataManager.this.activateHardcore();
            }
        }
    }

    public class Data
    extends SimpleSerializable {
        @Override
        public String saveToString() {
            return SaveHandler.save(Lists.newArrayList(QuestingDataManager.this.getQuestingData().values()), new TypeToken<List<QuestingData>>(){}.getType());
        }

        public String saveToString(Player player) {
            return "[" + SaveHandler.save(QuestingDataManager.this.getQuestingData(player), QuestingData.class) + "]";
        }

        @Override
        public String filePath() {
            return QuestingDataManager.DATA_FILE_PATH;
        }

        @Override
        public boolean isData() {
            return true;
        }

        @Override
        public void clear() {
            QuestingDataManager.this.questingData.clear();
        }

        @Override
        public void loadFromString(String string) {
            SaveHandler.load(string, new TypeToken<List<QuestingData>>(){}.getType()).ifPresent(list -> list.forEach(d -> QuestingDataManager.this.questingData.put(d.getPlayerId(), (QuestingData)d)));
        }
    }
}

