/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RepeatType {
    NONE("none", false){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getMessage(Quest quest, Player player, int days, int hours) {
            return Collections.emptyList();
        }
    }
    ,
    INSTANT("instant", false){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getMessage(Quest quest, Player player, int days, int hours) {
            return ImmutableList.of((Object)RepeatType.getMessageTitle(), (Object)Translator.translatable("hqm.repeat.instant.message", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getShortMessage(int days, int hours) {
            return ImmutableList.of((Object)Translator.translatable("hqm.repeat.instant.message", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
    }
    ,
    INTERVAL("interval", true){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getMessage(Quest quest, Player player, int days, int hours) {
            return ImmutableList.of((Object)RepeatType.getMessageTitle(), (Object)Translator.translatable("hqm.repeat.interval.message", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY), (Object)RepeatType.formatTime(days, hours), (Object)RepeatType.formatIntervalTime(quest, player, days, hours));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getShortMessage(int days, int hours) {
            return ImmutableList.of((Object)Translator.translatable("hqm.repeat.interval.message", new Object[0]).m_130946_(" (" + days + ":" + hours + ")").m_130940_(ChatFormatting.YELLOW));
        }
    }
    ,
    TIME("time", true){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getMessage(Quest quest, Player player, int days, int hours) {
            ArrayList tooltip = Lists.newArrayList((Object[])new FormattedText[]{RepeatType.getMessageTitle(), Translator.translatable("hqm.repeat.time.message", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY), RepeatType.formatTime(days, hours)});
            QuestData data = quest.getQuestData(player);
            if (!data.available) {
                tooltip.add(RepeatType.formatCooldownTime(quest, player, data, days, hours));
            }
            return tooltip;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<FormattedText> getShortMessage(int days, int hours) {
            return ImmutableList.of((Object)Translator.translatable("hqm.repeat.time.message", new Object[0]).m_130946_(" (" + days + ":" + hours + ")").m_130940_(ChatFormatting.YELLOW));
        }
    };

    private final String id;
    private final boolean useTime;

    private RepeatType(String id, boolean useTime) {
        this.id = id;
        this.useTime = useTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static FormattedText formatCooldownTime(Quest quest, Player player, QuestData data, int days, int hours) {
        int timerDuration = days * 24 + hours;
        long timerStart = data.time;
        long current = Quest.clientTicker.getHours();
        int remaining = (int)(timerStart + (long)timerDuration - current);
        return RepeatType.formatRemainingTime(quest, player, remaining / 24, remaining % 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static FormattedText formatIntervalTime(Quest quest, Player player, int days, int hours) {
        if (days == 0 && hours == 0) {
            return Translator.translatable("hqm.repeat.invalid", new Object[0]).m_130940_(ChatFormatting.DARK_RED);
        }
        int interval = days * 24 + hours;
        int remaining = interval - (int)(Quest.clientTicker.getHours() % (long)interval);
        return RepeatType.formatRemainingTime(quest, player, remaining / 24, remaining % 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static FormattedText formatRemainingTime(Quest quest, Player player, int days, int hours) {
        if (!quest.isAvailable(player)) {
            return Translator.translatable("hqm.repeat.resetIn", RepeatType.formatTime(days, hours)).m_130940_(ChatFormatting.YELLOW);
        }
        return Translator.translatable("hqm.repeat.nextReset", RepeatType.formatTime(days, hours)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static FormattedText formatTime(int days, int hours) {
        MutableComponent daysComp = Translator.plural("hqm.day", days);
        if (days > 0) {
            daysComp.m_130940_(ChatFormatting.GRAY);
        }
        MutableComponent hoursComp = Translator.plural("hqm.hour", hours);
        if (hours > 0) {
            hoursComp.m_130940_(ChatFormatting.GRAY);
        }
        return Translator.translatable("hqm.repeat.and", daysComp, hoursComp).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public FormattedText getName() {
        return Translator.translatable("hqm.repeat." + this.id + ".title", new Object[0]);
    }

    public FormattedText getDescription() {
        return Translator.translatable("hqm.repeat." + this.id + ".desc", new Object[0]);
    }

    public boolean isUseTime() {
        return this.useTime;
    }

    private static FormattedText getMessageTitle() {
        return Translator.translatable("hqm.repeat.repeatable", new Object[0]).m_130940_(ChatFormatting.YELLOW);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<FormattedText> getMessage(Quest var1, Player var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    public List<FormattedText> getShortMessage(int days, int hours) {
        return Collections.emptyList();
    }
}

