/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests;

import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.Translator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TriggerType {
    NONE("none", false, false){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return true;
        }

        @Override
        public Optional<FormattedText> getMessage(Quest quest) {
            return Optional.empty();
        }
    }
    ,
    QUEST_TRIGGER("quest", false, true){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return false;
        }
    }
    ,
    TASK_TRIGGER("task", true, true){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            if (quest.getTriggerTasks() >= quest.getTasks().size()) {
                return quest.isCompleted(playerId);
            }
            return quest.getTasks().get(quest.getTriggerTasks() - 1).isCompleted(playerId);
        }

        @Override
        public Optional<FormattedText> getMessage(Quest quest) {
            return Optional.of(this.getName().m_130946_(" (" + quest.getTriggerTasks() + ")").m_130940_(ChatFormatting.GOLD));
        }
    }
    ,
    ANTI_TRIGGER("anti", false, false){

        @Override
        public boolean isQuestVisible(Quest quest, UUID playerId) {
            return quest.isEnabled(playerId, false);
        }
    };

    private String id;
    private boolean useTaskCount;
    private boolean workAsInvisible;

    private TriggerType(String id, boolean useTaskCount, boolean workAsInvisible) {
        this.id = id;
        this.useTaskCount = useTaskCount;
        this.workAsInvisible = workAsInvisible;
    }

    public MutableComponent getName() {
        return Translator.translatable("hqm.trigger." + this.id + ".title", new Object[0]);
    }

    public FormattedText getDescription() {
        return Translator.translatable("hqm.trigger." + this.id + ".desc", new Object[0]);
    }

    public boolean isUseTaskCount() {
        return this.useTaskCount;
    }

    public boolean doesWorkAsInvisible() {
        return this.workAsInvisible;
    }

    public abstract boolean isQuestVisible(Quest var1, UUID var2);

    public Optional<FormattedText> getMessage(Quest quest) {
        return Optional.of(this.getName().m_130940_(ChatFormatting.GOLD));
    }
}

