/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class CompleteQuestTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String QUESTS = "quests";
    private final List<Boolean> quests;

    public CompleteQuestTaskData(int size) {
        this.quests = new ArrayList<Boolean>(size);
        while (this.quests.size() < size) {
            this.quests.add(false);
        }
    }

    public static CompleteQuestTaskData construct(JsonObject in) {
        CompleteQuestTaskData data = new CompleteQuestTaskData(GsonHelper.m_13927_((JsonObject)in, (String)COUNT));
        data.completed = GsonHelper.m_13855_((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = GsonHelper.m_13933_((JsonObject)in, (String)QUESTS);
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).getAsBoolean()) continue;
            data.complete(i);
        }
        return data;
    }

    public boolean getValue(int id) {
        if (id >= this.quests.size()) {
            return false;
        }
        return this.quests.get(id);
    }

    public void complete(int id) {
        while (id >= this.quests.size()) {
            this.quests.add(false);
        }
        this.quests.set(id, true);
    }

    public void mergeResult(CompleteQuestTaskData other) {
        for (int i = 0; i < other.quests.size(); ++i) {
            if (!other.quests.get(i).booleanValue()) continue;
            this.complete(i);
        }
    }

    public float getCompletedRatio(int size) {
        return (float)this.quests.stream().limit(size).filter(Boolean::booleanValue).count() / (float)size;
    }

    public boolean areAllCompleted(int size) {
        return this.quests.stream().limit(size).allMatch(Boolean::booleanValue);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.quests.size());
        builder.add(QUESTS, (JsonElement)Adapter.array(this.quests.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.quests.clear();
        this.quests.addAll(((CompleteQuestTaskData)taskData).quests);
    }
}

