/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class ItemsTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String PROGRESS = "progress";
    private final List<Integer> progress;

    public ItemsTaskData(int size) {
        this.progress = new ArrayList<Integer>(size);
        while (this.progress.size() < size) {
            this.progress.add(0);
        }
    }

    public static ItemsTaskData construct(JsonObject in) {
        ItemsTaskData data = new ItemsTaskData(GsonHelper.m_13927_((JsonObject)in, (String)COUNT));
        data.completed = GsonHelper.m_13855_((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = GsonHelper.m_13933_((JsonObject)in, (String)PROGRESS);
        for (int i = 0; i < array.size(); ++i) {
            data.progress.set(i, array.get(i).getAsInt());
        }
        return data;
    }

    public int getValue(int index) {
        if (index >= this.progress.size()) {
            return 0;
        }
        return this.progress.get(index);
    }

    public void setValue(int id, int amount) {
        while (id >= this.progress.size()) {
            this.progress.add(0);
        }
        this.progress.set(id, amount);
    }

    public void merge(ItemsTaskData other) {
        for (int i = 0; i < other.progress.size(); ++i) {
            this.setValue(i, Math.max(this.getValue(i), other.getValue(i)));
        }
    }

    public boolean isDone(int index, ItemRequirementTask.Part requirement) {
        return this.getValue(index) >= requirement.required;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.progress.size());
        builder.add(PROGRESS, (JsonElement)Adapter.array(this.progress.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.progress.clear();
        this.progress.addAll(((ItemsTaskData)taskData).progress);
    }
}

