/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class MobTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String KILLED = "killed";
    private final List<Integer> killed;

    public MobTaskData(int size) {
        this.killed = new ArrayList<Integer>(size);
        while (this.killed.size() < size) {
            this.killed.add(0);
        }
    }

    public static MobTaskData construct(JsonObject in) {
        MobTaskData data = new MobTaskData(GsonHelper.m_13927_((JsonObject)in, (String)COUNT));
        data.completed = GsonHelper.m_13855_((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = GsonHelper.m_13933_((JsonObject)in, (String)KILLED);
        for (int i = 0; i < array.size(); ++i) {
            data.setValue(i, array.get(i).getAsInt());
        }
        return data;
    }

    public int getValue(int id) {
        if (id >= this.killed.size()) {
            return 0;
        }
        return this.killed.get(id);
    }

    public void setValue(int id, int amount) {
        while (id >= this.killed.size()) {
            this.killed.add(0);
        }
        this.killed.set(id, amount);
    }

    public void merge(MobTaskData other) {
        for (int i = 0; i < other.killed.size(); ++i) {
            this.setValue(i, Math.max(this.getValue(i), other.getValue(i)));
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.killed.size());
        builder.add(KILLED, (JsonElement)Adapter.array(this.killed.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.killed.clear();
        this.killed.addAll(((MobTaskData)taskData).killed);
    }
}

