/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuestData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Boolean> claimableRewards = new ArrayList<Boolean>();
    private final List<TaskData> taskData = new ArrayList<TaskData>();
    public boolean completed;
    public boolean teamRewardClaimed;
    public boolean available = true;
    public long time;

    public QuestData(int players) {
        this.clearRewardClaims(players);
    }

    public QuestData() {
    }

    public void setRewardsFromSerialization(List<Boolean> claimableRewards) {
        this.claimableRewards.clear();
        this.claimableRewards.addAll(claimableRewards);
    }

    public Iterable<Boolean> getRewardsForSerialization() {
        return this.claimableRewards;
    }

    public void setTaskDataFromSerialization(List<TaskData> taskData) {
        this.taskData.clear();
        this.taskData.addAll(taskData);
    }

    public Iterable<TaskData> getTaskDataForSerialization() {
        return this.taskData;
    }

    public void clearRewardClaims(int players) {
        this.claimableRewards.clear();
        for (int i = 0; i < players; ++i) {
            this.claimableRewards.add(false);
        }
    }

    public boolean canClaimPlayerReward(int playerId) {
        return this.claimableRewards.get(playerId);
    }

    public void setCanClaimReward(int playerId, boolean canClaim) {
        this.claimableRewards.set(playerId, canClaim);
    }

    public void removePlayer(int playerId) {
        this.claimableRewards.remove(playerId);
    }

    public void insertPlayer(int playerId, boolean canClaim) {
        this.claimableRewards.add(playerId, canClaim);
    }

    public boolean canClaimPlayerReward(UUID playerId) {
        int id = this.getId(playerId);
        return id >= 0 && id < this.claimableRewards.size() && this.claimableRewards.get(id) != false;
    }

    public void claimReward(Quest quest, Player player) {
        boolean updateTeam = !this.teamRewardClaimed;
        this.teamRewardClaimed = true;
        Team team = QuestingDataManager.getInstance().getQuestingData(player).getTeam();
        if (!team.isSingle() && team.getRewardSetting() == RewardSetting.ANY) {
            this.claimFullReward();
            updateTeam = true;
        } else {
            this.claimReward(player.m_20148_());
        }
        if (updateTeam) {
            quest.sendUpdatedDataToTeam(player);
        } else if (player instanceof ServerPlayer) {
            quest.sendUpdatedData((ServerPlayer)player);
        }
    }

    private void claimReward(UUID playerId) {
        int id = this.getId(playerId);
        if (id >= 0 && id < this.claimableRewards.size()) {
            this.claimableRewards.set(id, false);
        }
    }

    private void claimFullReward() {
        Collections.fill(this.claimableRewards, false);
    }

    public void unlockRewardForAll() {
        Collections.fill(this.claimableRewards, true);
    }

    public void unlockRewardForRandom() {
        int rewardId = (int)(Math.random() * (double)this.claimableRewards.size());
        this.claimableRewards.set(rewardId, true);
    }

    private int getId(UUID playerId) {
        Team team = QuestingDataManager.getInstance().getQuestingData(playerId).getTeam();
        int id = 0;
        for (PlayerEntry entry : team.getPlayers()) {
            if (!entry.isInTeam()) continue;
            if (entry.getUUID().equals(playerId)) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    public boolean canClaimTeamRewards() {
        return this.completed && !this.teamRewardClaimed;
    }

    public void verifyTasksSize(Quest quest) {
        while (this.taskData.size() < quest.getTasks().size()) {
            this.taskData.add((TaskData)quest.getTasks().get(this.taskData.size()).newQuestData());
        }
    }

    public <Data extends TaskData> Data getTaskData(Quest quest, int id, Class<Data> clazz, Supplier<Data> emptySupplier) {
        this.verifyTasksSize(quest);
        TaskData data = this.taskData.get(id);
        if (clazz.isInstance(data)) {
            return (Data)((TaskData)clazz.cast(data));
        }
        LOGGER.warn("Found task data of wrong type. Expected {}, was {}. Replacing with empty data of the correct type.", clazz, data == null ? null : data.getClass());
        TaskData newData = (TaskData)emptySupplier.get();
        this.taskData.set(id, newData);
        return (Data)newData;
    }

    public void clearTaskData(Quest quest) {
        this.taskData.clear();
        this.verifyTasksSize(quest);
    }

    public void resetTaskData(int id, Supplier<? extends TaskData> emptySupplier) {
        if (id < this.taskData.size()) {
            this.taskData.set(id, emptySupplier.get());
        }
    }
}

