/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.data.TaskData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class TameTaskData
extends TaskData {
    private static final String COUNT = "count";
    private static final String TAMED = "tamed";
    private final List<Integer> tamed;

    public TameTaskData(int size) {
        this.tamed = new ArrayList<Integer>(size);
        while (this.tamed.size() < size) {
            this.tamed.add(0);
        }
    }

    public static TameTaskData construct(JsonObject in) {
        TameTaskData data = new TameTaskData(GsonHelper.m_13927_((JsonObject)in, (String)COUNT));
        data.completed = GsonHelper.m_13855_((JsonObject)in, (String)"completed", (boolean)false);
        JsonArray array = GsonHelper.m_13933_((JsonObject)in, (String)TAMED);
        for (int i = 0; i < array.size(); ++i) {
            data.setValue(i, array.get(i).getAsInt());
        }
        return data;
    }

    public int getValue(int id) {
        if (id >= this.tamed.size()) {
            return 0;
        }
        return this.tamed.get(id);
    }

    public void setValue(int id, int amount) {
        while (id >= this.tamed.size()) {
            this.tamed.add(0);
        }
        this.tamed.set(id, amount);
    }

    public void merge(TameTaskData other) {
        for (int i = 0; i < other.tamed.size(); ++i) {
            this.setValue(i, Math.max(this.getValue(i), other.getValue(i)));
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(COUNT, this.tamed.size());
        builder.add(TAMED, (JsonElement)Adapter.array(this.tamed.toArray()).build());
    }

    @Override
    public void update(TaskData taskData) {
        super.update(taskData);
        this.tamed.clear();
        this.tamed.addAll(((TameTaskData)taskData).tamed);
    }
}

