/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.reward;

import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.reward.CommandRewardList;
import hardcorequesting.common.forge.quests.reward.ItemStackRewardList;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QuestRewards {
    private final Quest quest;
    private final ItemStackRewardList rewards = new ItemStackRewardList();
    private final ItemStackRewardList rewardChoices = new ItemStackRewardList();
    private final CommandRewardList commandRewardList = new CommandRewardList();
    private List<ReputationReward> reputationRewards;

    public QuestRewards(Quest quest) {
        this.quest = quest;
    }

    public NonNullList<ItemStack> getReward() {
        return this.rewards.toList();
    }

    public void setReward(NonNullList<ItemStack> reward) {
        this.rewards.set(reward);
    }

    public NonNullList<ItemStack> getRewardChoice() {
        return this.rewardChoices.toList();
    }

    public void setRewardChoice(NonNullList<ItemStack> rewardChoice) {
        this.rewardChoices.set(rewardChoice);
    }

    public List<String> getCommandRewardsAsStrings() {
        return this.commandRewardList.asStrings();
    }

    public void setCommandRewards(List<String> commands) {
        this.commandRewardList.set(commands);
    }

    public void addCommand(String command) {
        this.commandRewardList.add(command);
    }

    public void editCommand(int id, String command) {
        this.commandRewardList.set(id, command);
    }

    public void removeCommand(int id) {
        this.commandRewardList.remove(id);
    }

    public List<ReputationReward> getReputationRewards() {
        return this.reputationRewards;
    }

    public void setReputationRewards(List<ReputationReward> reputationRewards) {
        this.reputationRewards = reputationRewards;
    }

    public boolean hasReward(UUID playerId) {
        return this.hasReward(this.quest.getQuestData(playerId), playerId);
    }

    public boolean hasReward(QuestData data, UUID playerId) {
        return this.isItemRewardAvailable(playerId, data) || this.isRepRewardAvailable(data) || this.isCommandRewardAvailable(data);
    }

    public boolean hasChoiceReward() {
        return !this.rewardChoices.isEmpty();
    }

    public void claimReward(Player player, int selectedReward) {
        QuestData data = this.quest.getQuestData(player);
        Result result = this.tryClaimItemReward(player, selectedReward, data);
        if (result == Result.FAIL) {
            return;
        }
        boolean claimedAny = result == Result.SUCCESS;
        claimedAny |= this.tryClaimReputationReward(player, data);
        if (claimedAny |= this.tryClaimCommandReward(player, data)) {
            data.claimReward(this.quest, player);
            SoundHandler.play(Sounds.COMPLETE, player);
        }
    }

    private boolean isItemRewardAvailable(UUID playerId, QuestData data) {
        return (!this.rewards.isEmpty() || !this.rewardChoices.isEmpty()) && data.canClaimPlayerReward(playerId);
    }

    private boolean isRepRewardAvailable(QuestData data) {
        return this.reputationRewards != null && data.canClaimTeamRewards();
    }

    private boolean isCommandRewardAvailable(QuestData data) {
        return !this.commandRewardList.isEmpty() && data.canClaimTeamRewards();
    }

    private Result tryClaimItemReward(Player player, int selectedReward, QuestData data) {
        if (this.isItemRewardAvailable(player.m_20148_(), data)) {
            List<ItemStack> itemsToAdd;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (!this.rewards.isEmpty()) {
                items.addAll((Collection<ItemStack>)this.rewards.toList());
            }
            if (!this.rewardChoices.isEmpty()) {
                if (selectedReward >= 0 && selectedReward < this.rewardChoices.size()) {
                    items.add((ItemStack)this.rewardChoices.getReward(selectedReward));
                } else {
                    return Result.FAIL;
                }
            }
            if (!QuestRewards.canInventoryHoldAll(player, itemsToAdd = QuestRewards.copyAndMergeStacks(items))) {
                return Result.FAIL;
            }
            QuestRewards.addItems(player, itemsToAdd);
            player.m_150109_().m_6596_();
            return Result.SUCCESS;
        }
        return Result.PASS;
    }

    private boolean tryClaimReputationReward(Player player, QuestData data) {
        if (this.isRepRewardAvailable(data)) {
            QuestingDataManager.getInstance().getQuestingData(player).getTeam().receiveAndSyncReputation(this.quest, this.reputationRewards);
            EventTrigger.instance().onReputationChange(new EventTrigger.ReputationEvent(player));
            return true;
        }
        return false;
    }

    private boolean tryClaimCommandReward(Player player, QuestData data) {
        if (this.isCommandRewardAvailable(data)) {
            this.commandRewardList.executeAll(player);
            return true;
        }
        return false;
    }

    public void setItemReward(ItemStack stack, int id, boolean isStandardReward) {
        ItemStackRewardList rewardList;
        ItemStackRewardList itemStackRewardList = rewardList = isStandardReward ? this.rewards : this.rewardChoices;
        if (id < rewardList.size()) {
            rewardList.set(id, stack);
            SaveHelper.add(EditType.REWARD_CHANGE);
        } else {
            SaveHelper.add(EditType.REWARD_CREATE);
            rewardList.add(stack);
        }
        this.quest.setIconIfEmpty(stack);
    }

    @NotNull
    public static List<ItemStack> copyAndMergeStacks(List<ItemStack> items) {
        ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            boolean added = false;
            for (ItemStack stack1 : itemsToAdd) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1)) continue;
                stack1.m_41769_(stack.m_41613_());
                added = true;
                break;
            }
            if (added) continue;
            itemsToAdd.add(stack.m_41777_());
        }
        return itemsToAdd;
    }

    public static boolean canInventoryHoldAll(Player player, List<ItemStack> items) {
        ArrayList<ItemStack> itemsToCheck = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            itemsToCheck.add(stack.m_41777_());
        }
        block1: for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack;
            stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            for (ItemStack stack1 : itemsToCheck) {
                if (stack1.m_41619_()) continue;
                if (stack.m_41619_()) {
                    stack1.m_41774_(stack1.m_41741_());
                    continue block1;
                }
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1)) continue;
                stack1.m_41774_(stack1.m_41741_() - stack.m_41613_());
                continue block1;
            }
        }
        return itemsToCheck.stream().allMatch(ItemStack::m_41619_);
    }

    public static void addItems(Player player, List<ItemStack> itemsToAdd) {
        block0: for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            Iterator<ItemStack> iterator = itemsToAdd.iterator();
            while (iterator.hasNext()) {
                int amount;
                ItemStack nextStack = iterator.next();
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack.m_41619_()) {
                    amount = Math.min(nextStack.m_41741_(), nextStack.m_41613_());
                    ItemStack copyStack = nextStack.m_41777_();
                    copyStack.m_41764_(amount);
                    player.m_150109_().f_35974_.set(i, (Object)copyStack);
                    nextStack.m_41774_(amount);
                    if (nextStack.m_41613_() > 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nextStack)) continue;
                amount = Math.min(nextStack.m_41741_() - stack.m_41613_(), nextStack.m_41613_());
                stack.m_41769_(amount);
                nextStack.m_41774_(amount);
                if (nextStack.m_41613_() > 0) continue block0;
                iterator.remove();
                continue block0;
            }
        }
    }

    private static enum Result {
        SUCCESS,
        PASS,
        FAIL;

    }
}

