/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.CompleteQuestTaskData;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CompleteQuestTask
extends QuestTask<CompleteQuestTaskData> {
    private static final String COMPLETED_QUESTS = "completed_quests";
    protected static final int LIMIT = 3;
    private final PartList<Part> parts = new PartList<Part>(Part::new, EditType.Type.COMPLETION, 3);

    public CompleteQuestTask(Quest parent) {
        super((TaskType)TaskType.COMPLETION.get(), CompleteQuestTaskData.class, parent);
        this.register(EventTrigger.Type.QUEST_COMPLETED, EventTrigger.Type.OPEN_BOOK);
    }

    public PartList<Part> getParts() {
        return this.parts;
    }

    public boolean completed(int id, UUID playerId) {
        return ((CompleteQuestTaskData)this.getData(playerId)).getValue(id);
    }

    public void setQuest(int id, UUID quest) {
        this.parts.getOrCreateForModify(id).setQuest(quest);
    }

    @Override
    public CompleteQuestTaskData newQuestData() {
        return new CompleteQuestTaskData(this.parts.size());
    }

    @Override
    public CompleteQuestTaskData loadData(JsonObject json) {
        return CompleteQuestTaskData.construct(json);
    }

    @Override
    public void onQuestCompleted(EventTrigger.QuestCompletedEvent event) {
        this.checkCompleted(event.getPlayer());
    }

    @Override
    public void onQuestSelected(EventTrigger.QuestSelectedEvent event) {
        this.checkCompleted(event.getPlayer());
    }

    @Override
    public void onUpdate(Player player) {
        this.checkCompleted(player);
    }

    private void checkCompleted(Player player) {
        Level world = player.m_20193_();
        if (!world.f_46443_ && !this.isCompleted(player) && player.m_20194_() != null) {
            CompleteQuestTaskData data = (CompleteQuestTaskData)this.getData(player);
            boolean completed = true;
            for (int i = 0; i < this.parts.size(); ++i) {
                Part task_quest;
                if (data.getValue(i) || (task_quest = this.parts.get(i)) == null || task_quest.getQuest() == null) continue;
                Quest quest = task_quest.getQuest();
                if (quest != null) {
                    if (quest.isCompleted(player)) {
                        data.complete(i);
                        continue;
                    }
                    completed = false;
                    continue;
                }
                completed = false;
            }
            if (completed && !this.parts.isEmpty()) {
                this.completeTask(player.m_20148_());
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        return ((CompleteQuestTaskData)this.getData(team)).getCompletedRatio(this.parts.size());
    }

    @Override
    public void mergeProgress(UUID uuid, CompleteQuestTaskData own, CompleteQuestTaskData other) {
        own.mergeResult(other);
        if (own.areAllCompleted(this.parts.size())) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(CompleteQuestTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.complete(i);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(CompleteQuestTaskData own, CompleteQuestTaskData other) {
        own.update(other);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(COMPLETED_QUESTS, (JsonElement)this.parts.write(QuestTaskAdapter.QUEST_COMPLETED_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(GsonHelper.m_13832_((JsonObject)object, (String)COMPLETED_QUESTS, (JsonArray)new JsonArray()), QuestTaskAdapter.QUEST_COMPLETED_ADAPTER);
    }

    public static class Part {
        private UUID quest_id;

        public Either<ItemStack, FluidStack> getIconStack() {
            Quest q = this.getQuest();
            return q != null ? q.getIconStack() : Either.left((Object)ItemStack.f_41583_);
        }

        public FormattedText getName() {
            Quest q = this.getQuest();
            return q != null ? q.getName() : Translator.plain("Use \"Select Quest\" to pick");
        }

        public void setQuest(UUID quest_id) {
            this.quest_id = quest_id;
        }

        public UUID getQuestId() {
            return this.quest_id;
        }

        public Quest getQuest() {
            if (this.getQuestId() == null) {
                return null;
            }
            return Quest.getQuest(this.getQuestId());
        }
    }
}

