/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.DeathTaskData;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DeathTask
extends QuestTask<DeathTaskData> {
    private static final String DEATHS = "deaths";
    private int deaths;

    public DeathTask(Quest parent) {
        super((TaskType)TaskType.DEATH.get(), DeathTaskData.class, parent);
        this.register(EventTrigger.Type.DEATH);
    }

    @Override
    public DeathTaskData newQuestData() {
        return new DeathTaskData();
    }

    @Override
    public DeathTaskData loadData(JsonObject json) {
        return DeathTaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        return (float)((DeathTaskData)this.getData(team)).getDeaths() / (float)this.deaths;
    }

    @Override
    public void mergeProgress(UUID playerID, DeathTaskData own, DeathTaskData other) {
        own.merge(other);
        if (own.getDeaths() == this.deaths) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(DeathTaskData data) {
        data.setDeaths(this.deaths);
        data.completed = true;
    }

    @Override
    public void copyProgress(DeathTaskData own, DeathTaskData other) {
        own.update(other);
    }

    @Override
    public void onLivingDeath(LivingEntity player, DamageSource source) {
        DeathTaskData deathData;
        if (player instanceof ServerPlayer && this.parent.isEnabled((Player)player) && this.parent.isAvailable((Player)player) && this.isVisible(player.m_20148_()) && !this.isCompleted((Player)player) && (deathData = (DeathTaskData)this.getData((Player)player)).getDeaths() < this.deaths) {
            deathData.setDeaths(deathData.getDeaths() + 1);
            if (deathData.getDeaths() == this.deaths) {
                this.completeTask(player.m_20148_());
            }
            this.parent.sendUpdatedDataToTeam((Player)player);
        }
    }

    @Override
    public void completeTask(UUID uuid) {
        super.completeTask(uuid);
        ((DeathTaskData)this.getData(uuid)).setDeaths(this.deaths);
        DeathTask.completeQuest(this.parent, uuid);
    }

    public int getDeaths(UUID id) {
        return ((DeathTaskData)this.getData(id)).getDeaths();
    }

    public int getDeathsRequired() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
        SaveHelper.add(EditType.DEATH_CHANGE);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(DEATHS, this.getDeathsRequired());
    }

    @Override
    public void read(JsonObject object) {
        this.deaths = GsonHelper.m_13824_((JsonObject)object, (String)DEATHS, (int)0);
    }
}

