/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import com.google.gson.JsonObject;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class QuestTask<Data extends TaskData> {
    private final TaskType<?> type;
    private final Class<Data> dataType;
    protected Quest parent;
    public WrappedText name;
    private WrappedText description;
    private int id;

    public QuestTask(TaskType<?> type, Class<Data> dataType, Quest parent) {
        this.type = type;
        this.dataType = dataType;
        this.parent = parent;
        this.name = WrappedText.createTranslated(type.getLangKeyName());
        this.description = WrappedText.createTranslated(type.getLangKeyDescription());
    }

    public TaskType<?> getType() {
        return this.type;
    }

    public static void completeQuest(Quest quest, UUID uuid) {
        Player player;
        if (!quest.isEnabled(uuid) || !quest.isAvailable(uuid)) {
            return;
        }
        for (QuestTask<?> questTask : quest.getTasks()) {
            if (((TaskData)questTask.getData((UUID)uuid)).completed) continue;
            return;
        }
        QuestData data = quest.getQuestData(uuid);
        data.completed = true;
        data.teamRewardClaimed = false;
        data.available = false;
        data.time = Quest.serverTicker.getHours();
        if (QuestingDataManager.getInstance().getQuestingData(uuid).getTeam().getRewardSetting() == RewardSetting.RANDOM) {
            data.unlockRewardForRandom();
        } else {
            data.unlockRewardForAll();
        }
        quest.sendUpdatedDataToTeam(uuid);
        TeamLiteStat.refreshTeam(QuestingDataManager.getInstance().getQuestingData(uuid).getTeam());
        for (Quest child : quest.getReversedRequirement()) {
            QuestTask.completeQuest(child, uuid);
            child.sendUpdatedDataToTeam(uuid);
        }
        if (quest.getRepeatInfo().getType() == RepeatType.INSTANT) {
            quest.reset(uuid);
        }
        if ((player = QuestingData.getPlayer(uuid)) instanceof ServerPlayer && !quest.hasReward(uuid)) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)Sounds.COMPLETE), (ServerPlayer)player);
        }
        if (player != null) {
            EventTrigger.instance().onQuestComplete(new EventTrigger.QuestCompletedEvent(player, quest.getQuestId()));
        }
    }

    public abstract void write(Adapter.JsonObjectBuilder var1);

    public abstract void read(JsonObject var1);

    public void updateId(int id) {
        this.id = id;
    }

    public boolean isCompleted(Player player) {
        return ((TaskData)this.getData((Player)player)).completed;
    }

    public boolean isCompleted(UUID uuid) {
        return ((TaskData)this.getData((UUID)uuid)).completed;
    }

    public boolean isVisible(UUID playerId) {
        if (this.id > 0) {
            QuestTask<?> requirement = this.parent.getTasks().get(this.id - 1);
            return requirement.isCompleted(playerId) && requirement.isVisible(playerId);
        }
        return true;
    }

    protected Data getData(Player player) {
        return this.getData(player.m_20148_());
    }

    public Data getData(UUID uuid) {
        return this.getData(this.parent.getQuestData(uuid));
    }

    protected Data getData(Team team) {
        return this.getData(team.getQuestData(this.parent.getQuestId()));
    }

    private Data getData(QuestData questData) {
        if (this.id < 0) {
            return this.newQuestData();
        }
        return (Data)questData.getTaskData(this.parent, this.id, this.dataType, this::newQuestData);
    }

    public abstract Data newQuestData();

    public abstract Data loadData(JsonObject var1);

    public MutableComponent getName() {
        return this.name.getText();
    }

    public WrappedText getRawName() {
        return this.name;
    }

    public void setName(WrappedText name) {
        this.name = name;
    }

    public MutableComponent getDescription() {
        return this.description.getText();
    }

    public WrappedText getRawDescription() {
        return this.description;
    }

    public void setDescription(WrappedText description) {
        this.description = description;
    }

    public void completeTask(UUID uuid) {
        ((TaskData)this.getData((UUID)uuid)).completed = true;
        QuestTask.completeQuest(this.parent, uuid);
    }

    public abstract void onUpdate(Player var1);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Quest getParent() {
        return this.parent;
    }

    public abstract float getCompletedRatio(Team var1);

    public void mergeProgress(UUID playerId, QuestData own, QuestData other) {
        this.mergeProgress(playerId, this.getData(own), this.getData(other));
    }

    public abstract void mergeProgress(UUID var1, Data var2, Data var3);

    public void resetData(UUID playerId) {
        this.parent.getQuestData(playerId).resetTaskData(this.id, this::newQuestData);
    }

    protected abstract void setComplete(Data var1);

    public void copyProgress(QuestData own, QuestData other) {
        this.copyProgress(this.getData(own), this.getData(other));
    }

    public void copyProgress(Data own, Data other) {
        ((TaskData)own).completed = ((TaskData)other).completed;
    }

    public void onDelete() {
        EventTrigger.instance().remove(this);
    }

    public void register(EventTrigger.Type ... types) {
        EventTrigger.instance().add(this, types);
    }

    public boolean isValid() {
        return this.getParent() != null && this.getParent().getTasks() != null && this.getParent().getTasks().contains(this);
    }

    public void onServerTick(MinecraftServer server) {
    }

    public void onPlayerTick(ServerPlayer playerEntity) {
    }

    public void onLivingDeath(LivingEntity entity, DamageSource source) {
    }

    public void onCrafting(Player player, ItemStack stack) {
    }

    public void onItemPickUp(Player playerEntity, ItemStack stack) {
    }

    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
    }

    public void onReputationChange(EventTrigger.ReputationEvent event) {
    }

    public void onAnimalTame(Player tamer, Entity entity) {
    }

    public void onAdvancement(ServerPlayer playerEntity) {
    }

    public void onQuestCompleted(EventTrigger.QuestCompletedEvent event) {
    }

    public void onQuestSelected(EventTrigger.QuestSelectedEvent event) {
    }

    public void onBlockPlaced(Level world, BlockState state, LivingEntity entity) {
    }

    public void onBlockBroken(BlockPos blockPos, BlockState blockState, Player player) {
    }

    public void onItemUsed(Player playerEntity, Level world, InteractionHand hand) {
    }

    public void onBlockUsed(Player playerEntity, Level world, InteractionHand hand) {
    }

    public void onRemovedReputation(Reputation reputation) {
    }

    public void onRemovedRepMarker(ReputationMarker marker) {
    }
}

