/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.CheckBoxTask;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.quests.task.DeathTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.quests.task.item.BreakBlockTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemQDSTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.quests.task.item.CraftingTask;
import hardcorequesting.common.forge.quests.task.item.DetectItemTask;
import hardcorequesting.common.forge.quests.task.item.PlaceBlockTask;
import hardcorequesting.common.forge.quests.task.reputation.HaveReputationTask;
import hardcorequesting.common.forge.quests.task.reputation.KillReputationTask;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class TaskType<T extends QuestTask<?>> {
    public static final ResourceKey<Registry<TaskType<?>>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("hardcorequesting", "task_type"));
    public static final DeferredRegister<TaskType<?>> REGISTER = DeferredRegister.create((String)"hardcorequesting", REGISTRY_KEY);
    public static final RegistrySupplier<TaskType<CheckBoxTask>> CHECKBOX = REGISTER.register("checkbox", () -> new TaskType<CheckBoxTask>("checkbox", CheckBoxTask::new));
    public static final RegistrySupplier<TaskType<ConsumeItemTask>> CONSUME = REGISTER.register("consume", () -> new TaskType<ConsumeItemTask>("consume", ConsumeItemTask::new));
    public static final RegistrySupplier<TaskType<CraftingTask>> CRAFT = REGISTER.register("craft", () -> new TaskType<CraftingTask>("craft", CraftingTask::new));
    public static final RegistrySupplier<TaskType<VisitLocationTask>> LOCATION = REGISTER.register("location", () -> new TaskType<VisitLocationTask>("location", VisitLocationTask::new));
    public static final RegistrySupplier<TaskType<ConsumeItemQDSTask>> CONSUME_QDS = REGISTER.register("consume_qds", () -> new TaskType<ConsumeItemQDSTask>("consumeQDS", ConsumeItemQDSTask::new));
    public static final RegistrySupplier<TaskType<DetectItemTask>> DETECT = REGISTER.register("detect", () -> new TaskType<DetectItemTask>("detect", DetectItemTask::new));
    public static final RegistrySupplier<TaskType<KillMobsTask>> KILL = REGISTER.register("kill", () -> new TaskType<KillMobsTask>("kill", KillMobsTask::new));
    public static final RegistrySupplier<TaskType<TameMobsTask>> TAME = REGISTER.register("tame", () -> new TaskType<TameMobsTask>("tame", TameMobsTask::new));
    public static final RegistrySupplier<TaskType<DeathTask>> DEATH = REGISTER.register("death", () -> new TaskType<DeathTask>("death", DeathTask::new));
    public static final RegistrySupplier<TaskType<HaveReputationTask>> REPUTATION = REGISTER.register("reputation", () -> new TaskType<HaveReputationTask>("reputation", HaveReputationTask::new));
    public static final RegistrySupplier<TaskType<KillReputationTask>> REPUTATION_KILL = REGISTER.register("reputation_kill", () -> new TaskType<KillReputationTask>("reputationKill", KillReputationTask::new));
    public static final RegistrySupplier<TaskType<GetAdvancementTask>> ADVANCEMENT = REGISTER.register("advancement", () -> new TaskType<GetAdvancementTask>("advancement", GetAdvancementTask::new));
    public static final RegistrySupplier<TaskType<CompleteQuestTask>> COMPLETION = REGISTER.register("completion", () -> new TaskType<CompleteQuestTask>("completion", CompleteQuestTask::new));
    public static final RegistrySupplier<TaskType<BreakBlockTask>> BLOCK_BREAK = REGISTER.register("block_break", () -> new TaskType<BreakBlockTask>("break", BreakBlockTask::new));
    public static final RegistrySupplier<TaskType<PlaceBlockTask>> BLOCK_PLACE = REGISTER.register("block_place", () -> new TaskType<PlaceBlockTask>("place", PlaceBlockTask::new));
    private final String id;
    private final TaskConstructor<T> constructor;

    private TaskType(String id, TaskConstructor<T> constructor) {
        this.id = id;
        this.constructor = constructor;
    }

    public static List<? extends TaskType<?>> values() {
        return REGISTER.getRegistrar().entrySet().stream().map(Map.Entry::getValue).toList();
    }

    public String toDataName() {
        return String.valueOf(REGISTER.getRegistrar().getId((Object)this));
    }

    public static TaskType<?> fromDataName(String str) {
        TaskType type;
        ResourceLocation id = ResourceLocation.m_135820_((String)str);
        if (id == null) {
            id = Objects.requireNonNull(ResourceLocation.m_214293_((String)"hardcorequesting", (String)str.toLowerCase(Locale.ROOT)), () -> "Not a valid task type name: %s".formatted(str));
        }
        if ((type = (TaskType)REGISTER.getRegistrar().get(id)) != null) {
            return type;
        }
        throw new IllegalArgumentException("Not a valid task type name: %s".formatted(str));
    }

    public T addTask(Quest quest) {
        T task = this.constructor.create(quest);
        ((QuestTask)task).updateId(quest.getTasks().size());
        quest.getTasks().add((QuestTask<?>)task);
        SaveHelper.add(EditType.TASK_CREATE);
        return task;
    }

    public String getLangKeyDescription() {
        return "hqm.taskType." + this.id + ".desc";
    }

    public String getLangKeyName() {
        return "hqm.taskType." + this.id + ".title";
    }

    public FormattedText getDescription() {
        return Translator.translatable(this.getLangKeyDescription(), new Object[0]);
    }

    public FormattedText getName() {
        return Translator.translatable(this.getLangKeyName(), new Object[0]);
    }

    public static interface TaskConstructor<T extends QuestTask<?>> {
        public T create(Quest var1);
    }
}

