/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.AdvancementTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GetAdvancementTask
extends IconLayoutTask<Part, AdvancementTaskData> {
    private static final String ADVANCEMENTS = "advancements";

    public GetAdvancementTask(Quest parent) {
        super((TaskType)TaskType.ADVANCEMENT.get(), AdvancementTaskData.class, EditType.Type.ADVANCEMENT, parent);
        this.register(EventTrigger.Type.ADVANCEMENT, EventTrigger.Type.OPEN_BOOK);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    public boolean advanced(int id, UUID playerId) {
        return ((AdvancementTaskData)this.getData(playerId)).getValue(id);
    }

    public void setAdvancement(int id, String advancement) {
        ((Part)this.parts.getOrCreateForModify(id)).setAdvancement(advancement);
    }

    @Override
    public AdvancementTaskData newQuestData() {
        return new AdvancementTaskData(this.parts.size());
    }

    @Override
    public AdvancementTaskData loadData(JsonObject json) {
        return AdvancementTaskData.construct(json);
    }

    @Override
    public void onAdvancement(ServerPlayer playerEntity) {
        this.checkAdvancement((Player)playerEntity);
    }

    @Override
    public void onUpdate(Player player) {
        this.checkAdvancement(player);
    }

    private void checkAdvancement(Player player) {
        Level world = player.m_20193_();
        if (!world.f_46443_ && !this.isCompleted(player) && player.m_20194_() != null) {
            AdvancementTaskData data = (AdvancementTaskData)this.getData(player);
            boolean completed = true;
            ServerAdvancementManager manager = player.m_20194_().m_129889_();
            PlayerAdvancements playerAdvancements = player.m_20194_().m_6846_().m_11296_((ServerPlayer)player);
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part;
                if (data.getValue(i) || (part = (Part)this.parts.get(i)) == null || part.getAdvancement() == null) continue;
                ResourceLocation advResource = new ResourceLocation(part.getAdvancement());
                Advancement advAdvancement = manager.m_136041_(advResource);
                if (advAdvancement == null) {
                    completed = false;
                    continue;
                }
                AdvancementProgress progress = playerAdvancements.m_135996_(advAdvancement);
                if (progress.m_8193_()) {
                    data.complete(i);
                    continue;
                }
                completed = false;
            }
            if (completed && this.parts.size() > 0) {
                this.completeTask(player.m_20148_());
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        return ((AdvancementTaskData)this.getData(team)).getCompletedRatio(this.parts.size());
    }

    @Override
    public void mergeProgress(UUID uuid, AdvancementTaskData own, AdvancementTaskData other) {
        own.mergeResult(other);
        if (own.areAllCompleted(this.parts.size())) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(AdvancementTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.complete(i);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(AdvancementTaskData own, AdvancementTaskData other) {
        own.update(other);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(ADVANCEMENTS, (JsonElement)this.parts.write(QuestTaskAdapter.ADVANCEMENT_TASK_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(GsonHelper.m_13832_((JsonObject)object, (String)ADVANCEMENTS, (JsonArray)new JsonArray()), QuestTaskAdapter.ADVANCEMENT_TASK_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private String adv_name;

        public void setAdvancement(String name) {
            this.adv_name = name;
        }

        public String getAdvancement() {
            return this.adv_name;
        }

        public void setAdvancement(ResourceLocation name) {
            this.setAdvancement(name.toString());
        }
    }
}

