/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.Objects;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class IconLayoutTask<T extends Part, Data extends TaskData>
extends QuestTask<Data> {
    protected static final int LIMIT = 4;
    protected final PartList<T> parts;

    public IconLayoutTask(TaskType<? extends IconLayoutTask<T, Data>> type, Class<Data> dataType, EditType.Type editType, Quest parent) {
        super(type, dataType, parent);
        this.parts = new PartList<Part>(this::createEmpty, editType, 4);
    }

    public PartList<T> getParts() {
        return this.parts;
    }

    protected abstract T createEmpty();

    public void setIcon(int id, Either<ItemStack, FluidStack> stack) {
        ((Part)this.parts.getOrCreateForModify(id)).setIconStack(stack);
        this.parent.setIconIfEmpty(stack);
    }

    public void setName(int id, WrappedText str) {
        ((Part)this.parts.getOrCreateForModify(id)).setName(str);
    }

    public static abstract class Part {
        private Either<ItemStack, FluidStack> iconStack = Either.left((Object)ItemStack.f_41583_);
        private WrappedText name = WrappedText.create("New");

        public Either<ItemStack, FluidStack> getIconStack() {
            return this.iconStack;
        }

        public boolean hasNoIcon() {
            return (Boolean)this.iconStack.map(ItemStack::m_41619_, FluidStack::isEmpty);
        }

        public void setIconStack(@NotNull Either<ItemStack, FluidStack> iconStack) {
            this.iconStack = iconStack;
        }

        public MutableComponent getName() {
            return this.name.getText();
        }

        public WrappedText getRawName() {
            return this.name;
        }

        public void setName(WrappedText name) {
            this.name = Objects.requireNonNull(name);
        }
    }
}

