/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.MobTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class KillMobsTask
extends IconLayoutTask<Part, MobTaskData> {
    private static final String MOBS = "mobs";

    public KillMobsTask(Quest parent) {
        super((TaskType)TaskType.KILL.get(), MobTaskData.class, EditType.Type.MONSTER, parent);
        this.register(EventTrigger.Type.DEATH);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    public static Player getKiller(DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public void setInfo(int id, ResourceLocation mobId, int amount) {
        Part part = (Part)this.parts.getOrCreateForModify(id);
        part.setMob(mobId);
        part.setCount(amount);
    }

    public int killed(int id, UUID playerId) {
        return ((MobTaskData)this.getData(playerId)).getValue(id);
    }

    @Override
    public MobTaskData newQuestData() {
        return new MobTaskData(this.parts.size());
    }

    @Override
    public MobTaskData loadData(JsonObject json) {
        return MobTaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        MobTaskData data = (MobTaskData)this.getData(team);
        int killed = 0;
        int total = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            int req = ((Part)this.parts.get((int)i)).count;
            killed += Math.min(req, data.getValue(i));
            total += req;
        }
        return (float)killed / (float)total;
    }

    @Override
    public void mergeProgress(UUID playerID, MobTaskData own, MobTaskData other) {
        own.merge(other);
        boolean all = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (own.getValue(i) >= ((Part)this.parts.get((int)i)).count) continue;
            all = false;
            break;
        }
        if (all) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(MobTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.setValue(i, ((Part)this.parts.get((int)i)).count);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(MobTaskData own, MobTaskData other) {
        own.update(other);
    }

    @Override
    public void onLivingDeath(LivingEntity entity, DamageSource source) {
        Player killer = KillMobsTask.getKiller(source);
        if (killer != null && this.parent.isEnabled(killer) && this.parent.isAvailable(killer) && this.isVisible(killer.m_20148_()) && !this.isCompleted(killer)) {
            MobTaskData data = (MobTaskData)this.getData(killer);
            boolean updated = false;
            for (int i = 0; i < this.parts.size(); ++i) {
                EntityType type;
                Part part = (Part)this.parts.get(i);
                if (part.count <= data.getValue(i) || (type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(part.mobId)) == null || !type.equals(entity.m_6095_())) continue;
                data.setValue(i, data.getValue(i) + 1);
                updated = true;
            }
            if (updated) {
                boolean done = true;
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.killed(i, killer.m_20148_()) >= part.count) continue;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeTask(killer.m_20148_());
                }
                this.parent.sendUpdatedDataToTeam(killer);
            }
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(MOBS, (JsonElement)this.parts.write(QuestTaskAdapter.MOB_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(GsonHelper.m_13832_((JsonObject)object, (String)MOBS, (JsonArray)new JsonArray()), QuestTaskAdapter.MOB_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private ResourceLocation mobId = BuiltInRegistries.f_256780_.m_122315_();
        private int count = 1;

        public ResourceLocation getMob() {
            return this.mobId;
        }

        public void setMob(ResourceLocation mobId) {
            this.mobId = BuiltInRegistries.f_256780_.m_6612_(mobId).isPresent() ? mobId : BuiltInRegistries.f_256780_.m_122315_();
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

