/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.TameTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TameMobsTask
extends IconLayoutTask<Part, TameTaskData> {
    private static final String TAME = "part";
    public static final ResourceLocation ABSTRACT_HORSE = new ResourceLocation("abstracthorse");

    public TameMobsTask(Quest parent) {
        super((TaskType)TaskType.TAME.get(), TameTaskData.class, EditType.Type.MONSTER, parent);
        this.register(EventTrigger.Type.ANIMAL_TAME);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInfo(int id, String entityId, int amount) {
        SpawnEggItem egg;
        EntityType entityType;
        Part part = (Part)this.parts.getOrCreateForModify(id);
        part.setTame(entityId);
        part.setCount(amount);
        if (entityId != null && (part.hasNoIcon() || part.getIconStack().left().orElse(ItemStack.f_41583_).m_41720_() instanceof SpawnEggItem) && (entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(entityId))) != null && (egg = SpawnEggItem.m_43213_((EntityType)entityType)) != null) {
            part.setIconStack((Either<ItemStack, FluidStack>)Either.left((Object)new ItemStack((ItemLike)egg)));
            this.parent.setIconIfEmpty(new ItemStack((ItemLike)egg));
        }
    }

    public int tamed(int id, UUID playerId) {
        return ((TameTaskData)this.getData(playerId)).getValue(id);
    }

    @Override
    public TameTaskData newQuestData() {
        return new TameTaskData(this.parts.size());
    }

    @Override
    public TameTaskData loadData(JsonObject json) {
        return TameTaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        TameTaskData data = (TameTaskData)this.getData(team);
        int tamed = 0;
        int total = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            int req = ((Part)this.parts.get((int)i)).count;
            tamed += Math.min(req, data.getValue(i));
            total += req;
        }
        return (float)tamed / (float)total;
    }

    @Override
    public void mergeProgress(UUID uuid, TameTaskData own, TameTaskData other) {
        own.merge(other);
        boolean all = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (own.getValue(i) >= ((Part)this.parts.get((int)i)).count) continue;
            all = false;
            break;
        }
        if (all) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void setComplete(TameTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.setValue(i, ((Part)this.parts.get((int)i)).count);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(TameTaskData own, TameTaskData other) {
        own.update(other);
    }

    @Override
    public void onAnimalTame(Player tamer, Entity entity) {
        if (tamer != null && this.parent.isEnabled(tamer) && this.parent.isAvailable(tamer) && this.isVisible(tamer.m_20148_()) && !this.isCompleted(tamer)) {
            TameTaskData data = (TameTaskData)this.getData(tamer);
            boolean updated = false;
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part = (Part)this.parts.get(i);
                if (part.count <= data.getValue(i) || part.mobId == null) continue;
                if (part.mobId.equals(ABSTRACT_HORSE.toString())) {
                    if (!(entity instanceof AbstractHorse)) continue;
                    data.setValue(i, data.getValue(i) + 1);
                    updated = true;
                    continue;
                }
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(part.mobId));
                if (type == null || !type.equals(entity.m_6095_())) continue;
                data.setValue(i, data.getValue(i) + 1);
                updated = true;
            }
            if (updated) {
                boolean done = true;
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.tamed(i, tamer.m_20148_()) >= part.count) continue;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeTask(tamer.m_20148_());
                }
                this.parent.sendUpdatedDataToTeam(tamer);
            }
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(TAME, (JsonElement)this.parts.write(QuestTaskAdapter.TAME_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(GsonHelper.m_13832_((JsonObject)object, (String)TAME, (JsonArray)new JsonArray()), QuestTaskAdapter.TAME_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        private String mobId;
        private int count = 1;

        public String getTame() {
            return this.mobId;
        }

        public void setTame(String part) {
            this.mobId = part;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

