/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.LocationTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Translator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VisitLocationTask
extends IconLayoutTask<Part, LocationTaskData> {
    private static final String LOCATIONS = "locations";
    private static final int CHECK_DELAY = 20;
    private int delay = 1;

    public VisitLocationTask(Quest parent) {
        super((TaskType)TaskType.LOCATION.get(), LocationTaskData.class, EditType.Type.LOCATION, parent);
        this.register(EventTrigger.Type.SERVER, EventTrigger.Type.PLAYER);
    }

    @Override
    protected Part createEmpty() {
        return new Part();
    }

    private void tick(Player player, boolean isPlayerEvent) {
        if (!isPlayerEvent) {
            ++this.delay;
        } else if (this.delay >= 0) {
            this.delay = 0;
            Level world = player.m_20193_();
            if (!world.f_46443_) {
                LocationTaskData data = (LocationTaskData)this.getData(player);
                boolean all = true;
                boolean updated = false;
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (data.getValue(i) || !Objects.equals(player.m_20193_().m_46472_().m_135782_().toString(), part.dimension)) continue;
                    int current = (int)player.m_20275_((double)part.pos.m_123341_() + 0.5, (double)part.pos.m_123342_() + 0.5, (double)part.pos.m_123343_() + 0.5);
                    int target = part.radius * part.radius;
                    if (part.radius >= 0 && current > target) {
                        all = false;
                        continue;
                    }
                    if (this.isCompleted(player) || !this.isVisible(player.m_20148_()) || !this.parent.isEnabled(player) || !this.parent.isAvailable(player)) continue;
                    updated = true;
                    data.complete(i);
                }
                if (updated) {
                    if (all) {
                        this.completeTask(player.m_20148_());
                    }
                    this.parent.sendUpdatedDataToTeam(player);
                }
            }
        }
    }

    public boolean visited(int id, UUID playerId) {
        return ((LocationTaskData)this.getData(playerId)).getValue(id);
    }

    public void setInfo(int id, Visibility visibility, BlockPos pos, int radius, String dimension) {
        Part part = (Part)this.parts.getOrCreateForModify(id);
        part.setVisibility(visibility);
        part.setPosition(pos);
        part.setRadius(radius);
        part.setDimension(dimension);
    }

    @Override
    public LocationTaskData newQuestData() {
        return new LocationTaskData(this.parts.size());
    }

    @Override
    public LocationTaskData loadData(JsonObject json) {
        return LocationTaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public float getCompletedRatio(Team team) {
        return ((LocationTaskData)this.getData(team)).getCompletedRatio(this.parts.size());
    }

    @Override
    public void mergeProgress(UUID playerID, LocationTaskData own, LocationTaskData other) {
        own.mergeResult(other);
        if (own.areAllCompleted(this.parts.size())) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(LocationTaskData data) {
        for (int i = 0; i < this.parts.size(); ++i) {
            data.complete(i);
        }
        data.completed = true;
    }

    @Override
    public void copyProgress(LocationTaskData own, LocationTaskData other) {
        own.update(other);
    }

    @Override
    public void onServerTick(MinecraftServer server) {
        this.tick(null, false);
    }

    @Override
    public void onPlayerTick(ServerPlayer playerEntity) {
        if (!playerEntity.m_9236_().f_46443_) {
            this.tick((Player)playerEntity, true);
        }
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(LOCATIONS, (JsonElement)this.parts.write(QuestTaskAdapter.LOCATION_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        this.parts.read(GsonHelper.m_13832_((JsonObject)object, (String)LOCATIONS, (JsonArray)new JsonArray()), QuestTaskAdapter.LOCATION_ADAPTER);
    }

    public static class Part
    extends IconLayoutTask.Part {
        @NotNull
        private BlockPos pos = BlockPos.f_121853_;
        private int radius = 3;
        private Visibility visibility = Visibility.LOCATION;
        private String dimension;

        public BlockPos getPosition() {
            return this.pos;
        }

        public void setPosition(BlockPos pos) {
            this.pos = pos;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public void setVisibility(Visibility visibility) {
            this.visibility = visibility;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    public static enum Visibility {
        FULL("Full", true, true),
        LOCATION("Location", true, false),
        NONE("None", false, false);

        private final boolean showCoordinate;
        private final boolean showRadius;
        private final String id;

        private Visibility(String id, boolean showCoordinate, boolean showRadius) {
            this.id = id;
            this.showCoordinate = showCoordinate;
            this.showRadius = showRadius;
        }

        public boolean doShowCoordinate() {
            return this.showCoordinate;
        }

        public boolean doShowRadius() {
            return this.showRadius;
        }

        public FormattedText getName() {
            return Translator.translatable("hqm.locationMenu.vis" + this.id + ".title", new Object[0]);
        }

        public FormattedText getDescription() {
            return Translator.translatable("hqm.locationMenu.vis" + this.id + ".desc", new Object[0]);
        }
    }
}

