/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.item;

import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.util.FluidUtils;
import hardcorequesting.common.forge.util.Fraction;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConsumeItemTask
extends ItemRequirementTask {
    public ConsumeItemTask(Quest parent) {
        this((TaskType)TaskType.CONSUME.get(), parent);
    }

    protected ConsumeItemTask(TaskType<? extends ConsumeItemTask> type, Quest parent) {
        super(type, parent);
    }

    public boolean increaseFluid(FluidStack fluidVolume, UUID playerId, boolean action) {
        boolean updated = false;
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            Fraction amount;
            ItemRequirementTask.Part item = (ItemRequirementTask.Part)this.parts.get(i);
            if (data.isDone(i, item) || fluidVolume == null || !item.isFluid(fluidVolume.getFluid())) continue;
            Fraction fraction = amount = FluidUtils.getAmount(fluidVolume).isLessThan(Fraction.ofWhole(item.required - data.getValue(i))) ? FluidUtils.getAmount(fluidVolume) : Fraction.ofWhole(item.required - data.getValue(i));
            if (action) {
                data.setValue(i, data.getValue(i) + amount.intValue());
            }
            FluidUtils.split(fluidVolume, amount);
            updated = true;
            break;
        }
        return action && updated;
    }

    public boolean canTakeItem(ItemStack stack, UUID playerId) {
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part part = (ItemRequirementTask.Part)this.parts.get(i);
            if (!part.isStack(stack) || data.isDone(i, part)) continue;
            return true;
        }
        return false;
    }

    public boolean canTakeFluid(Fluid fluid, UUID playerId) {
        ItemsTaskData data = (ItemsTaskData)this.getData(playerId);
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part part = (ItemRequirementTask.Part)this.parts.get(i);
            if (!part.isFluid(fluid) || data.isDone(i, part)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(Player player) {
        if (this.increaseItems((NonNullList<ItemStack>)player.m_150109_().f_35974_, player.m_20148_())) {
            player.m_150109_().m_6596_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mayUseFluids() {
        return true;
    }
}

