/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.item;

import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DetectItemTask
extends ItemRequirementTask {
    public DetectItemTask(Quest parent) {
        super((TaskType)TaskType.DETECT.get(), parent);
        this.register(EventTrigger.Type.CRAFTING, EventTrigger.Type.PICK_UP, EventTrigger.Type.OPEN_BOOK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mayUseFluids() {
        return true;
    }

    @Override
    public void doCompletionCheck(ItemsTaskData data, UUID playerID) {
        boolean isDone = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part item = (ItemRequirementTask.Part)this.parts.get(i);
            if (data.isDone(i, item)) continue;
            data.setValue(i, 0);
            isDone = false;
        }
        if (isDone) {
            this.completeTask(playerID);
        }
        this.parent.sendUpdatedDataToTeam(playerID);
    }

    @Override
    public void onUpdate(Player player) {
        this.countItems(player, ItemStack.f_41583_);
    }

    @Override
    public void onItemPickUp(Player playerEntity, ItemStack stack) {
        this.countItems(playerEntity, stack);
    }

    @Override
    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
        if (event.isRealName()) {
            this.countItems(event.getPlayer(), ItemStack.f_41583_);
        }
    }

    @Override
    public void onCrafting(Player player, ItemStack stack) {
        if (player != null) {
            if ((stack = stack.m_41777_()).m_41613_() == 0) {
                stack.m_41764_(1);
            }
            this.countItems(player, stack);
        }
    }

    private void countItems(Player player, ItemStack stack) {
        if (!player.m_20193_().f_46443_) {
            NonNullList items = NonNullList.m_122780_((int)(player.m_150109_().f_35974_.size() + 1), (Object)ItemStack.f_41583_);
            Collections.copy(items, player.m_150109_().f_35974_);
            if (!stack.m_41619_()) {
                items.set(items.size() - 1, (Object)stack);
            }
            this.countItems((NonNullList<ItemStack>)items, (ItemsTaskData)this.getData(player), player.m_20148_());
        }
    }

    public void countItems(NonNullList<ItemStack> itemsToCount, ItemsTaskData data, UUID playerID) {
        if (!this.parent.isAvailable(playerID)) {
            return;
        }
        boolean updated = false;
        for (int i = 0; i < this.parts.size(); ++i) {
            ItemRequirementTask.Part part = (ItemRequirementTask.Part)this.parts.get(i);
            if (data.isDone(i, part)) continue;
            for (ItemStack stack : itemsToCount) {
                if (part.isStack(stack)) {
                    int amount = Math.min(stack.m_41613_(), part.required - data.getValue(i));
                    data.setValue(i, data.getValue(i) + amount);
                    updated = true;
                }
                if (part.hasItem()) continue;
                for (FluidStack fluidStack : HardcoreQuestingCore.platform.findFluidsIn(stack)) {
                    if (!part.isFluid(fluidStack.getFluid())) continue;
                    int amount = Math.min((int)fluidStack.getAmount(), part.required - data.getValue(i));
                    data.setValue(i, data.getValue(i) + amount);
                    updated = true;
                }
            }
        }
        if (updated) {
            this.doCompletionCheck(data, playerID);
        }
    }
}

