/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.reputation;

import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.team.Team;
import net.minecraft.world.entity.player.Player;

public class HaveReputationTask
extends ReputationTask<TaskData> {
    public HaveReputationTask(Quest parent) {
        super((TaskType)TaskType.REPUTATION.get(), TaskData.class, parent);
        this.register(EventTrigger.Type.OPEN_BOOK, EventTrigger.Type.REPUTATION_CHANGE);
    }

    private void checkReputation(Player player) {
        if (this.parent.isEnabled(player) && this.parent.isAvailable(player) && this.isVisible(player.m_20148_()) && !this.isCompleted(player) && this.isPlayerInRange(player)) {
            this.completeTask(player.m_20148_());
            this.parent.sendUpdatedDataToTeam(player);
        }
    }

    @Override
    public float getCompletedRatio(Team team) {
        int count = this.parts.size();
        if (count == 0) {
            return 0.0f;
        }
        int valid = 0;
        for (ReputationTask.Part setting : this.parts) {
            if (!setting.isValid(team)) continue;
            ++valid;
        }
        return (float)valid / (float)count;
    }

    @Override
    public TaskData newQuestData() {
        return new TaskData();
    }

    @Override
    public TaskData loadData(JsonObject json) {
        return TaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public void onOpenBook(EventTrigger.BookOpeningEvent event) {
        this.checkReputation(event.getPlayer());
    }

    @Override
    public void onReputationChange(EventTrigger.ReputationEvent event) {
        this.checkReputation(event.getPlayer());
    }
}

