/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.reputation;

import com.google.gson.JsonObject;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.ReputationKillTaskData;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class KillReputationTask
extends ReputationTask<ReputationKillTaskData> {
    private static final String KILLS = "kills";
    private int kills;

    public KillReputationTask(Quest parent) {
        super((TaskType)TaskType.REPUTATION_KILL.get(), ReputationKillTaskData.class, parent);
        this.register(EventTrigger.Type.DEATH);
    }

    @Override
    public float getCompletedRatio(Team team) {
        return (float)((ReputationKillTaskData)this.getData((Team)team)).kills / (float)this.kills;
    }

    @Override
    public void mergeProgress(UUID playerID, ReputationKillTaskData own, ReputationKillTaskData other) {
        own.kills = Math.max(own.kills, other.kills);
        if (own.kills == this.kills) {
            this.completeTask(playerID);
        }
    }

    @Override
    public void setComplete(ReputationKillTaskData data) {
        data.kills = this.kills;
        super.setComplete(data);
    }

    @Override
    public ReputationKillTaskData newQuestData() {
        return new ReputationKillTaskData();
    }

    @Override
    public ReputationKillTaskData loadData(JsonObject json) {
        return ReputationKillTaskData.construct(json);
    }

    @Override
    public void onUpdate(Player player) {
    }

    @Override
    public void copyProgress(ReputationKillTaskData own, ReputationKillTaskData other) {
        super.copyProgress(own, other);
        own.kills = other.kills;
    }

    @Override
    public void onLivingDeath(LivingEntity entity, DamageSource source) {
        Player killer = KillMobsTask.getKiller(source);
        if (killer != null && this.parent.isEnabled(killer) && this.parent.isAvailable(killer) && this.isVisible(killer.m_20148_()) && !this.isCompleted(killer) && !killer.equals((Object)entity) && entity instanceof Player && this.isPlayerInRange((Player)entity)) {
            ReputationKillTaskData killData = (ReputationKillTaskData)this.getData(killer);
            if (killData.kills < this.kills) {
                ++killData.kills;
                if (killData.kills == this.kills) {
                    this.completeTask(killer.m_20148_());
                }
                this.parent.sendUpdatedDataToTeam(killer);
            }
        }
    }

    public int getKills(UUID id) {
        return ((ReputationKillTaskData)this.getData((UUID)id)).kills;
    }

    public int getKillsRequirement() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
        SaveHelper.add(EditType.KILLS_CHANGE);
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        super.write(builder);
        builder.add(KILLS, this.getKillsRequirement());
    }

    @Override
    public void read(JsonObject object) {
        super.read(object);
        this.kills = GsonHelper.m_13824_((JsonObject)object, (String)KILLS, (int)0);
    }
}

