/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.quests.task.reputation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestTaskAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public abstract class ReputationTask<Data extends TaskData>
extends QuestTask<Data> {
    private static final String REPUTATION = "reputation";
    protected static final int LIMIT = 4;
    protected final PartList<Part> parts = new PartList<Part>(Part::new, EditType.Type.REPUTATION_TASK, 4);

    protected ReputationTask(TaskType<? extends ReputationTask<Data>> type, Class<Data> dataType, Quest parent) {
        super(type, dataType, parent);
    }

    public PartList<Part> getParts() {
        return this.parts;
    }

    @Deprecated
    public List<Part> getSettings() {
        return this.parts.getElements();
    }

    public void setSetting(int id, Part setting) {
        this.parts.set(id, setting);
    }

    protected boolean isPlayerInRange(Player player) {
        if (!this.parts.isEmpty()) {
            Object data = this.getData(player);
            if (!((TaskData)data).completed && !player.m_20193_().f_46443_) {
                for (Part setting : this.parts) {
                    if (setting.isValid(QuestingDataManager.getInstance().getQuestingData(player).getTeam())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void mergeProgress(UUID playerID, Data own, Data other) {
        ((TaskData)own).completed |= ((TaskData)other).completed;
    }

    @Override
    public void setComplete(Data data) {
        ((TaskData)data).completed = true;
    }

    @Override
    public void write(Adapter.JsonObjectBuilder builder) {
        builder.add(REPUTATION, (JsonElement)this.parts.write(QuestTaskAdapter.REPUTATION_TASK_ADAPTER));
    }

    @Override
    public void read(JsonObject object) {
        ArrayList<QuestTaskAdapter.ReputationSettingConstructor> list = new ArrayList<QuestTaskAdapter.ReputationSettingConstructor>();
        for (JsonElement element : GsonHelper.m_13832_((JsonObject)object, (String)REPUTATION, (JsonArray)new JsonArray())) {
            QuestTaskAdapter.ReputationSettingConstructor constructor = QuestTaskAdapter.ReputationSettingConstructor.read(element);
            if (constructor == null) continue;
            list.add(constructor);
        }
        QuestTaskAdapter.taskReputationListMap.put(this, list);
    }

    @Override
    public void onRemovedReputation(Reputation reputation) {
        this.parts.getElements().removeIf(setting -> reputation.equals(setting.getReputation()));
    }

    @Override
    public void onRemovedRepMarker(ReputationMarker marker) {
        for (Part setting : this.parts) {
            if (marker.equals(setting.getLower())) {
                setting.setLower(null);
            }
            if (!marker.equals(setting.getUpper())) continue;
            setting.setUpper(null);
        }
    }

    public static class Part {
        private final Reputation reputation;
        private ReputationMarker lower;
        private ReputationMarker upper;
        private final boolean inverted;

        private Part() {
            this(null, null, null, false);
        }

        public Part(Reputation reputation, ReputationMarker lower, ReputationMarker upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public Reputation getReputation() {
            return this.reputation;
        }

        public ReputationMarker getLower() {
            return this.lower;
        }

        public void setLower(ReputationMarker lower) {
            this.lower = lower;
        }

        public ReputationMarker getUpper() {
            return this.upper;
        }

        public void setUpper(ReputationMarker upper) {
            this.upper = upper;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isValid(Team team) {
            if (this.getReputation() == null || !this.getReputation().isValid()) {
                return false;
            }
            ReputationMarker current = this.getReputation().getCurrentMarker(team.getReputation(this.getReputation()));
            return !(this.lower != null && this.lower.getValue() > current.getValue() || this.upper != null && current.getValue() > this.upper.getValue()) != this.inverted;
        }
    }
}

