/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.reputation;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Reputation {
    public static final int BAR_SRC_X = 0;
    public static final int BAR_SRC_Y = 101;
    public static final int BAR_WIDTH = 125;
    public static final int BAR_HEIGHT = 3;
    public static final int BAR_X = 0;
    public static final int BAR_Y = 5;
    private static final int ARROW_SRC_POINTER_X = 0;
    private static final int ARROW_SRC_MARKER_X = 10;
    private static final int ARROW_SRC_NEUTRAL_X = 20;
    private static final int ARROW_MARKER_OFFSET = 5;
    private static final int ARROW_MARKER_Y = 1;
    private static final int ARROW_POINTER_Y = -5;
    private static final int ARROW_SRC_Y = 93;
    private static final int ARROW_SIZE = 5;
    private static final int TEXT_X = 5;
    private static final int TEXT_Y = 14;
    private String uuid;
    private WrappedText name;
    private final ReputationMarker neutral;
    private final List<ReputationMarker> markers;

    public Reputation() {
        Map<String, Reputation> reputationMap = ReputationManager.getInstance().reputationMap;
        do {
            this.uuid = UUID.randomUUID().toString();
        } while (reputationMap.containsKey(this.uuid));
        this.name = WrappedText.create("Unnamed");
        this.neutral = new ReputationMarker(WrappedText.create("Neutral"), 0, true);
        this.markers = new ArrayList<ReputationMarker>();
    }

    public Reputation(String id, WrappedText name, WrappedText neutralName) {
        Map<String, Reputation> reputationMap = ReputationManager.getInstance().reputationMap;
        this.uuid = id;
        while (this.uuid == null || reputationMap.containsKey(this.uuid)) {
            this.uuid = UUID.randomUUID().toString();
        }
        this.name = name;
        this.neutral = new ReputationMarker(neutralName, 0, true);
        this.markers = new ArrayList<ReputationMarker>();
    }

    public String getId() {
        return this.uuid;
    }

    public MutableComponent getNeutralName() {
        return this.neutral.getName();
    }

    public WrappedText getRawNeutralName() {
        return this.neutral.getRawName();
    }

    public void setNeutralName(WrappedText name) {
        this.neutral.setName(name);
    }

    public void sort() {
        Collections.sort(this.markers);
        for (int i = 0; i < this.markers.size(); ++i) {
            this.markers.get(i).setId(i);
        }
        this.neutral.setId(this.markers.size());
    }

    public int getValue(Player player) {
        return this.getValue(player.m_20148_());
    }

    public int getValue(UUID playerID) {
        return QuestingDataManager.getInstance().getQuestingData(playerID).getTeam().getReputation(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedText drawAndGetTooltip(GuiGraphics graphics, GuiQuestBook gui, int x, int y, int mX, int mY, FormattedText info, UUID playerId, boolean effects, ReputationMarker lower, ReputationMarker upper, boolean inverted, ReputationMarker active, FormattedText text, boolean completed) {
        this.draw(graphics, gui, x, y, mX, mY, playerId, effects, lower, upper, inverted, active, text, completed);
        return info != null ? info : this.getTooltip(gui, x, y, mX, mY, playerId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, GuiQuestBook gui, int x, int y, int mX, int mY, UUID playerId, boolean effects, ReputationMarker lower, ReputationMarker upper, boolean inverted, ReputationMarker active, FormattedText text, boolean completed) {
        FormattedText info;
        FormattedText error = this.getError();
        if (error != null) {
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, x + 0, y + 5, 0, 101, 125, 3);
            gui.drawString(graphics, error, x + 5, y + 14, 0.7f, 0xFF5555);
            return;
        }
        int lowerValue = 0;
        int upperValue = 0;
        boolean lowerMoved = false;
        boolean upperMoved = false;
        boolean lowerMovedInner = false;
        boolean upperMovedInner = false;
        boolean lowerOnMarker = false;
        boolean upperOnMarker = false;
        if (effects) {
            int i;
            if (lower == null) {
                lowerValue = Math.min(this.markers.get(0).getValue(), 0);
            } else {
                lowerValue = lower.getValue();
                boolean bl = lowerOnMarker = lower.getId() == 0 && lower.getValue() > 0;
                if (lower.isNeutral()) {
                    lowerOnMarker = true;
                    lowerMovedInner = true;
                    lowerMoved = true;
                } else if (lower.getId() == this.markers.size() - 1) {
                    lowerOnMarker = true;
                } else if (lowerValue <= 0) {
                    for (i = 0; i < this.markers.size(); ++i) {
                        if (this.markers.get(i).getValue() < lowerValue) continue;
                        lowerValue = this.markers.get(i).getValue();
                        if (i - 1 == 0) break;
                        lowerMoved = true;
                        break;
                    }
                }
            }
            if (upper == null) {
                upperValue = Math.max(this.markers.get(this.markers.size() - 1).getValue(), 0);
            } else {
                upperValue = upper.getValue();
                boolean bl = upperOnMarker = upper.getId() == this.markers.size() - 1 && upper.getValue() < 0;
                if (upper.isNeutral()) {
                    upperOnMarker = true;
                    upperMovedInner = true;
                    upperMoved = true;
                } else if (upper.getId() == 0) {
                    upperOnMarker = true;
                } else if (upperValue >= 0) {
                    for (i = this.markers.size() - 1; i >= 0; --i) {
                        if (this.markers.get(i).getValue() > upperValue) continue;
                        upperValue = this.markers.get(i).getValue();
                        if (i + 1 != this.markers.size()) break;
                        upperMoved = true;
                        break;
                    }
                }
            }
        }
        int normalSrcY = 101;
        int selectedSrcY = 98;
        if (effects && inverted) {
            normalSrcY = selectedSrcY;
            selectedSrcY = 101;
        }
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, x + 0, y + 5, 0, normalSrcY, 125, 3);
        if (effects) {
            int leftX = this.getPointerPosition(lowerValue, lowerOnMarker);
            if (lowerMoved) {
                leftX += lowerMovedInner ? 1 : 6;
            }
            int rightX = this.getPointerPosition(upperValue, upperOnMarker) + 1;
            if (upperMoved) {
                rightX -= upperMovedInner ? 1 : 5;
            }
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, x + 0 + leftX, y + 5, 0 + leftX, selectedSrcY, rightX - leftX, 3);
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            int position = i * 115 / (this.markers.size() - 1);
            int markerX = x + 0 - 2 + position + 5;
            int markerY = y + 5 + 1;
            int srcX = 10;
            int value = this.markers.get(i).getValue();
            if (gui.inBounds(markerX, markerY, 5, 5, mX, mY)) {
                srcX += 5;
            }
            boolean selected = this.markers.get(i).equals(active) || effects && (lowerValue <= value && value <= upperValue) != inverted;
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, markerX, markerY, srcX, 93 + (selected ? -5 : 0), 5, 5);
        }
        ReputationMarker current = null;
        int value = 0;
        if (playerId != null) {
            value = this.getValue(playerId);
            current = this.getCurrentMarker(value);
            this.drawPointer(graphics, gui, value, x, y, -5, 0, mX, mY, false);
        }
        this.drawPointer(graphics, gui, 0, x, y, 1, 20, mX, mY, this.neutral.equals(active) || effects && (lowerValue <= 0 && 0 <= upperValue) != inverted);
        boolean selected = false;
        if (text != null) {
            info = text;
        } else if (current == null || lower != null || upper != null) {
            if (lower == null && upper == null) {
                info = Translator.translatable("hqm.rep" + (inverted ? "no" : "any") + "ValueOf", this.getName()).m_130940_(ChatFormatting.DARK_RED);
            } else {
                MutableComponent upperName;
                MutableComponent lowerName;
                MutableComponent mutableComponent = lower == null ? null : (lowerName = Screen.m_96638_() ? Translator.text(String.valueOf(lower.getValue())) : lower.getName());
                MutableComponent mutableComponent2 = upper == null ? null : (upperName = Screen.m_96638_() ? Translator.text(String.valueOf(upper.getValue())) : upper.getName());
                if (lower != null && upper != null) {
                    if (lower.equals(upper)) {
                        info = inverted ? Translator.translatable("hqm.rep.not_equals", this.getName(), lowerName) : Translator.translatable("hqm.rep.equals", this.getName(), lowerName);
                    } else {
                        info = Translator.translatable("hqm.rep.between", lowerName, this.getName(), upperName);
                        if (inverted) {
                            info = Translator.translatable("hqm.rep.not", info);
                        }
                    }
                } else {
                    info = lower != null ? Translator.translatable(inverted ? "hqm.rep.min_inverted" : "hqm.rep.min", this.getName(), lowerName) : Translator.translatable(inverted ? "hqm.rep.max_inverted" : "hqm.rep.max", this.getName(), upperName);
                }
            }
        } else {
            info = Translator.translatable("hqm.rep.current", this.getName(), current.getName(), value);
            selected = completed || effects && (lowerValue <= current.getValue() && current.getValue() <= upperValue) != inverted;
        }
        gui.drawString(graphics, info, x + 5, y + 14, 0.7f, selected ? 0x40AA40 : 0x404040);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedText getTooltip(GuiQuestBook gui, int x, int y, int mX, int mY, UUID playerId) {
        if (this.getError() != null) {
            return null;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            int markerY;
            int position = i * 115 / (this.markers.size() - 1);
            int markerX = x + 0 - 2 + position + 5;
            if (!gui.inBounds(markerX, markerY = y + 5 + 1, 5, 5, mX, mY)) continue;
            return this.markers.get(i).getLabel();
        }
        if (playerId != null) {
            int value = this.getValue(playerId);
            ReputationMarker current = this.getCurrentMarker(value);
            if (this.isOnPointer(gui, value, x, y, -5, mX, mY)) {
                return current.getLabel();
            }
        }
        if (this.isOnPointer(gui, 0, x, y, 1, mX, mY)) {
            return this.neutral.getName();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private FormattedText getError() {
        String error = null;
        if (this.markers.size() < 2) {
            error = "atLeastTwo";
        } else {
            for (ReputationMarker marker : this.markers) {
                if (marker.getValue() == 0) {
                    error = "notZero";
                } else {
                    for (ReputationMarker marker2 : this.markers) {
                        if (marker.equals(marker2) || marker.getValue() != marker2.getValue()) continue;
                        error = "unique";
                        break;
                    }
                }
                if (error == null) continue;
                break;
            }
        }
        return error == null ? null : Translator.translatable("hqm.rep." + error, new Object[0]);
    }

    public ReputationMarker getCurrentMarker(int value) {
        ReputationMarker current = this.neutral;
        if (value != 0) {
            for (ReputationMarker marker : this.markers) {
                if (value > 0 && marker.getValue() > 0 && value >= marker.getValue()) {
                    current = marker;
                    continue;
                }
                if (value >= 0 || marker.getValue() >= 0 || value > marker.getValue()) continue;
                current = marker;
                break;
            }
        }
        return current;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawPointer(GuiGraphics graphics, GuiQuestBook gui, int value, int x, int y, int offsetY, int srcX, int mX, int mY, boolean selectedTexture) {
        int pointerY;
        int pointerX = x + 0 - 2 + this.getPointerPosition(value, true);
        if (gui.inBounds(pointerX, pointerY = y + 5 + offsetY, 5, 5, mX, mY)) {
            srcX += 5;
        }
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, pointerX, pointerY, srcX, 93 + (selectedTexture ? -5 : 0), 5, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isOnPointer(GuiQuestBook gui, int value, int x, int y, int offsetY, int mX, int mY) {
        int pointerX = x + 0 - 2 + this.getPointerPosition(value, true);
        int pointerY = y + 5 + offsetY;
        return gui.inBounds(pointerX, pointerY, 5, 5, mX, mY);
    }

    private int getPointerPosition(int value, boolean onMarker) {
        int pointerPosition = 124;
        for (int i = 0; i < this.markers.size(); ++i) {
            boolean pointAtMarker;
            ReputationMarker marker = this.markers.get(i);
            if (value > marker.getValue()) continue;
            boolean bl = pointAtMarker = onMarker && value == marker.getValue();
            if (pointAtMarker) {
                pointerPosition = 5 + i * 115 / (this.markers.size() - 1);
                break;
            }
            if (i == this.markers.size() - 1 && marker.getValue() == value) {
                pointerPosition = 124;
                break;
            }
            if (i == 0) {
                pointerPosition = 0;
                break;
            }
            ReputationMarker prevMarker = this.markers.get(i - 1);
            int span = marker.getValue() - prevMarker.getValue();
            int internalValue = value - prevMarker.getValue();
            pointerPosition = 5 + (int)(((float)(i - 1) + (float)internalValue / (float)span) * 115.0f / (float)(this.markers.size() - 1));
            break;
        }
        return pointerPosition;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ReputationMarker onActiveClick(GuiQuestBook gui, int x, int y, int mX, int mY) {
        int pointerY;
        if (this.getError() != null) {
            return null;
        }
        int pointerX = x + 0 - 2 + this.getPointerPosition(0, true);
        if (gui.inBounds(pointerX, pointerY = y + 5 + 1, 5, 5, mX, mY)) {
            return this.neutral;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            int markerY;
            int position = i * 115 / (this.markers.size() - 1);
            int markerX = x + 0 - 2 + position + 5;
            if (!gui.inBounds(markerX, markerY = y + 5 + 1, 5, 5, mX, mY)) continue;
            return this.markers.get(i);
        }
        return null;
    }

    public MutableComponent getName() {
        return this.name.getText();
    }

    public WrappedText getRawName() {
        return this.name;
    }

    public void setName(WrappedText name) {
        this.name = name;
    }

    public void clearMarkers() {
        this.markers.clear();
        this.sort();
    }

    public void add(ReputationMarker marker) {
        this.markers.add(marker);
        this.sort();
    }

    public void remove(ReputationMarker marker) {
        for (Quest quest : Quest.getQuests().values()) {
            for (QuestTask<?> task : quest.getTasks()) {
                task.onRemovedRepMarker(marker);
            }
        }
        this.markers.remove(marker);
        this.sort();
    }

    public ReputationMarker getMarker(int i) {
        if (i == this.markers.size()) {
            return this.neutral;
        }
        return this.markers.get(i);
    }

    public boolean isValid() {
        return this.markers.size() >= 2;
    }

    public int getMarkerCount() {
        return this.markers.size();
    }

    public List<ReputationMarker> getMarkers() {
        return Collections.unmodifiableList(this.markers);
    }
}

