/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.reputation;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.PickReputationMenu;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReputationBar {
    private String repId;
    private int x;
    private int y;

    public ReputationBar(Reputation reputation, int x, int y) {
        this(reputation.getId(), x, y);
    }

    public ReputationBar(String repId, int x, int y) {
        this.repId = repId;
        this.x = x;
        this.y = y;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getRepId() {
        return this.repId;
    }

    public Reputation getReputation() {
        return ReputationManager.getInstance().getReputation(this.repId);
    }

    public void setReputation(Reputation reputation) {
        this.repId = reputation.getId();
    }

    public boolean isValid() {
        return ReputationManager.getInstance().getReputation(this.repId) != null;
    }

    public boolean sameLocation(ReputationBar reputationBar) {
        return reputationBar != null && reputationBar.x == this.x && reputationBar.y == this.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, GuiQuestBook gui, int mX, int mY, UUID playerId) {
        Reputation reputation = ReputationManager.getInstance().getReputation(this.repId);
        if (reputation == null) {
            return;
        }
        gui.applyColor(-1);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        FormattedText info = reputation.drawAndGetTooltip(graphics, gui, this.x, this.y, mX, mY, null, playerId, false, null, null, false, null, null, false);
        if (info != null) {
            gui.renderTooltip(graphics, info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean inBounds(int mX, int mY) {
        return this.x <= mX && this.x + 125 >= mX && this.y - 9 <= mY && this.y + 18 >= mY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiQuestBook gui, QuestSet set, int x, int y) {
        if (this.inBounds(x, y)) {
            switch (gui.getCurrentMode()) {
                case MOVE: {
                    gui.modifyingBar = this;
                    SaveHelper.add(EditType.REPUTATION_BAR_MOVE);
                    break;
                }
                case REP_BAR_CHANGE: {
                    PickReputationMenu.display(gui, this.getReputation(), reputation -> {
                        this.setReputation((Reputation)reputation);
                        SaveHelper.add(EditType.REPUTATION_BAR_CHANGE);
                    });
                    break;
                }
                case DELETE: {
                    set.removeRepBar(this);
                    SaveHelper.add(EditType.REPUTATION_BAR_REMOVE);
                }
            }
        }
    }
}

