/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.reputation;

import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.reputation.Reputation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReputationManager
extends SimpleSerializable {
    public static final String FILE_PATH = "reputations.json";
    final Map<String, Reputation> reputationMap = new HashMap<String, Reputation>();

    public static ReputationManager getInstance() {
        return QuestLine.getActiveQuestLine().reputationManager;
    }

    public Map<String, Reputation> getReputations() {
        return this.reputationMap;
    }

    public List<Reputation> getReputationList() {
        return new ArrayList<Reputation>(this.reputationMap.values());
    }

    public Reputation getReputation(String id) {
        return this.reputationMap.get(id);
    }

    public void addReputation(Reputation reputation) {
        this.reputationMap.put(reputation.getId(), reputation);
    }

    public void removeReputation(Reputation reputation) {
        for (Quest quest : Quest.getQuests().values()) {
            for (QuestTask<?> task : quest.getTasks()) {
                task.onRemovedReputation(reputation);
            }
            List<ReputationReward> rewards = quest.getRewards().getReputationRewards();
            if (rewards == null) continue;
            rewards.removeIf(reward -> reputation.equals(reward.getReward()));
        }
        this.getReputations().remove(reputation.getId());
    }

    public int size() {
        return this.reputationMap.size();
    }

    @Override
    public String filePath() {
        return FILE_PATH;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.getReputationList(), new TypeToken<List<Reputation>>(){}.getType());
    }

    @Override
    public void clear() {
        this.reputationMap.clear();
    }

    @Override
    public void loadFromString(String string) {
        SaveHandler.load(string, new TypeToken<List<Reputation>>(){}.getType()).ifPresent(reputations -> reputations.forEach(this::addReputation));
    }
}

