/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.adapter.Adapter;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class PlayerEntry {
    private static final String ENTRY_UUID = "uuid";
    private static final String ENTRY_OWNER = "owner";
    private static final String ENTRY_IN_TEAM = "inTeam";
    private static final String ENTRY_NAME = "name";
    private UUID uuid;
    private boolean inTeam;
    private boolean owner;
    private String playerName = null;

    private PlayerEntry() {
    }

    public PlayerEntry(UUID uuid, boolean inTeam, boolean owner) {
        this();
        this.uuid = uuid;
        this.inTeam = inTeam;
        this.owner = owner;
    }

    public static PlayerEntry read(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        PlayerEntry playerEntry = new PlayerEntry();
        playerEntry.uuid = UUID.fromString(GsonHelper.m_13906_((JsonObject)object, (String)ENTRY_UUID));
        playerEntry.owner = GsonHelper.m_13912_((JsonObject)object, (String)ENTRY_OWNER);
        playerEntry.inTeam = GsonHelper.m_13912_((JsonObject)object, (String)ENTRY_IN_TEAM);
        playerEntry.playerName = (String)StringUtils.defaultIfEmpty((CharSequence)GsonHelper.m_13851_((JsonObject)object, (String)ENTRY_NAME, null), null);
        return playerEntry;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getDisplayName() {
        if (this.playerName == null) {
            ServerPlayer entry;
            MinecraftServer server = HardcoreQuestingCore.getServer();
            if (server != null && (entry = server.m_6846_().m_11259_(this.getUUID())) != null) {
                this.playerName = entry.m_6302_();
                return (String)StringUtils.defaultIfEmpty((CharSequence)this.playerName, (CharSequence)"");
            }
            if (HardcoreQuestingCore.platform.isClient()) {
                this.playerName = this.getDisplayNameClient();
                return (String)StringUtils.defaultIfEmpty((CharSequence)this.playerName, (CharSequence)"");
            }
        }
        return Objects.toString(this.playerName);
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getDisplayNameClient() {
        Player entry = Minecraft.m_91087_().f_91073_.m_46003_(this.getUUID());
        if (entry != null) {
            return entry.m_6302_();
        }
        return null;
    }

    public boolean isInTeam() {
        return this.inTeam;
    }

    public void setInTeam(boolean inTeam) {
        this.inTeam = inTeam;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerEntry entry = (PlayerEntry)o;
        return Objects.equals(this.uuid, entry.uuid);
    }

    public JsonElement toJson() {
        return Adapter.object().add(ENTRY_UUID, this.uuid.toString()).add(ENTRY_OWNER, this.owner).add(ENTRY_IN_TEAM, this.inTeam).add(ENTRY_NAME, this.getDisplayName()).build();
    }

    public ServerPlayer getPlayerMP() {
        return HardcoreQuestingCore.getServer().m_6846_().m_11259_(this.getUUID());
    }
}

