/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.TeamMessage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.LifeSetting;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.TeamAction;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.team.TeamUpdateSize;
import hardcorequesting.common.forge.team.TeamUpdateType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Team {
    public static boolean reloadedInvites;
    @Nullable
    private UUID id = null;
    private List<PlayerEntry> players = new ArrayList<PlayerEntry>();
    private final List<Team> invites;
    private String name;
    private Map<String, Integer> reputation;
    private Map<UUID, QuestData> questData;
    private int clientTeamLives = -1;
    private RewardSetting rewardSetting = RewardSetting.getDefault();
    private LifeSetting lifeSetting = LifeSetting.SHARE;

    private Team(UUID uuid) {
        if (uuid != null) {
            this.players.add(new PlayerEntry(uuid, true, true));
        }
        this.createQuestData();
        this.createReputation();
        this.invites = new ArrayList<Team>();
    }

    public static Team single(UUID player) {
        return new Team(player);
    }

    public static Team empty() {
        return new Team(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return this.isSingle() || team.isSingle() ? Objects.equals(this.players.get(0), team.players.get(0)) : Objects.equals(this.id, team.id);
    }

    public int hashCode() {
        return this.isSingle() ? Objects.hash(this.players.get(0)) : Objects.hash(this.id);
    }

    public static void declineAll(UUID playerID) {
        block0: for (Team team : TeamManager.getInstance().getTeams()) {
            Iterator<PlayerEntry> iterator = team.getPlayers().iterator();
            while (iterator.hasNext()) {
                PlayerEntry playerEntry = iterator.next();
                if (playerEntry.isInTeam() || !playerEntry.getUUID().equals(playerID)) continue;
                iterator.remove();
                team.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                continue block0;
            }
        }
    }

    public void resetProgress(Quest quest) {
        this.questData.put(quest.getQuestId(), Quest.getQuest(quest.getQuestId()).createData(this.getPlayerCount()));
        this.refreshData();
    }

    public void resetCompletion(Quest quest) {
        QuestData data = this.getQuestData(quest.getQuestId());
        data.completed = false;
        data.teamRewardClaimed = false;
        data.available = true;
        this.refreshData();
    }

    public Map<UUID, QuestData> getQuestData() {
        return this.questData;
    }

    public TeamLiteStat toLiteStat() {
        return new TeamLiteStat(this.name, this.getPlayerCount(), this.getSharedLives(), this.getProgress());
    }

    public float getProgress() {
        int completed = 0;
        int total = 0;
        for (QuestData data : this.questData.values()) {
            if (data == null) continue;
            ++total;
            if (!data.completed) continue;
            ++completed;
        }
        return (float)completed / (float)total;
    }

    public void receiveAndSyncReputation(Quest quest, List<ReputationReward> reputationList) {
        for (ReputationReward reputationReward : reputationList) {
            this.setReputation((Reputation)reputationReward.getReward(), this.getReputation((Reputation)reputationReward.getReward()) + reputationReward.getValue());
        }
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.isInTeam()) continue;
            NetworkManager.sendToPlayer(TeamUpdateType.REPUTATION_RECEIVED.build(this, quest, reputationList), entry.getPlayerMP());
        }
    }

    public RewardSetting getRewardSetting() {
        return this.rewardSetting;
    }

    public void setRewardSetting(RewardSetting rewardSetting) {
        this.rewardSetting = rewardSetting;
    }

    public LifeSetting getLifeSetting() {
        return this.lifeSetting;
    }

    public void setLifeSetting(LifeSetting lifeSetting) {
        this.lifeSetting = lifeSetting;
    }

    public UUID getId() {
        return this.id == null ? Util.f_137441_ : this.id;
    }

    public void setId(@Nullable UUID id) {
        this.id = Objects.equals(id, Util.f_137441_) ? null : id;
    }

    public boolean isSharingLives() {
        return this.lifeSetting == LifeSetting.SHARE;
    }

    public int getSharedLives() {
        if (this.clientTeamLives != -1) {
            return this.clientTeamLives;
        }
        int lives = 0;
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.isInTeam()) continue;
            lives += QuestingDataManager.getInstance().getQuestingData(entry.getUUID()).getRawLives();
        }
        return lives;
    }

    public int getPlayerCount() {
        return (int)this.players.stream().filter(PlayerEntry::isInTeam).count();
    }

    public void addPlayer(PlayerEntry entry) {
        this.players.add(entry);
    }

    public void removePlayer(Player toBeRemoved) {
        int id = 0;
        Iterator<PlayerEntry> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            PlayerEntry player = iterator.next();
            if (player.getUUID().equals(toBeRemoved.m_20148_())) {
                QuestData data;
                QuestData leaveData;
                Team newSingleTeam = Team.single(toBeRemoved.m_20148_());
                for (UUID i : this.questData.keySet()) {
                    leaveData = newSingleTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null) continue;
                    leaveData.setCanClaimReward(0, data.canClaimPlayerReward(id));
                    data.removePlayer(id);
                }
                iterator.remove();
                for (UUID i : this.questData.keySet()) {
                    leaveData = newSingleTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null || Quest.getQuest(i) == null) continue;
                    Quest.getQuest(i).copyProgress(leaveData, data);
                }
                ReputationManager reputationManager = ReputationManager.getInstance();
                for (String i : reputationManager.getReputations().keySet()) {
                    Reputation reputation = reputationManager.getReputation(i);
                    if (reputation == null) continue;
                    newSingleTeam.setReputation(reputation, this.getReputation(reputation));
                }
                QuestingDataManager.getInstance().getQuestingData(toBeRemoved).setTeam(newSingleTeam);
                this.refreshTeamData(player, TeamUpdateSize.ONLY_MEMBERS);
                newSingleTeam.refreshTeamData(player, TeamUpdateSize.ONLY_MEMBERS);
                NetworkManager.sendToPlayer(TeamUpdateType.LEAVE_TEAM.build(this, player.getUUID(), newSingleTeam), player.getPlayerMP());
                break;
            }
            ++id;
        }
    }

    public void refreshTeamData(TeamUpdateSize type) {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, type);
        }
    }

    private void refreshTeamData(PlayerEntry entry, TeamUpdateSize type) {
        boolean valid = false;
        switch (type) {
            case ALL: {
                valid = true;
                break;
            }
            case ONLY_MEMBERS: {
                valid = entry.isInTeam();
                break;
            }
            case ONLY_OWNER: {
                valid = entry.isOwner();
            }
        }
        if (valid) {
            NetworkManager.sendToPlayer(TeamUpdateType.FULL.build(this, new Object[0]), entry.getPlayerMP());
        }
    }

    public void refreshTeamLives() {
        if (!this.isSingle() && this.isSharingLives()) {
            for (PlayerEntry entry : this.getPlayers()) {
                NetworkManager.sendToPlayer(TeamUpdateType.LIVES.build(this, new Object[0]), entry.getPlayerMP());
            }
        }
    }

    public void refreshData() {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, TeamUpdateSize.ALL);
        }
    }

    public void clearProgress() {
        this.questData.clear();
        this.createQuestData();
        int playerCount = this.getPlayerCount();
        for (Quest quest : Quest.getQuests().values()) {
            if (quest == null || this.questData.get(quest.getQuestId()) == null) continue;
            this.questData.get(quest.getQuestId()).clearRewardClaims(playerCount);
        }
        this.refreshData();
    }

    public void deleteTeam() {
        if (this.isSingle()) {
            throw new IllegalStateException("Tried to delete a single team.");
        }
        for (int i = this.players.size() - 1; i >= 0; --i) {
            PlayerEntry player = this.players.get(i);
            if (player.isInTeam()) {
                this.removePlayer((Player)player.getPlayerMP());
                continue;
            }
            this.players.remove(i);
        }
        QuestingDataManager questingDataManager = QuestingDataManager.getInstance();
        TeamManager.getInstance().removeTeam(this);
        NetworkManager.sendToAllPlayers(TeamUpdateType.REMOVE_TEAM.build(this, new Object[0]));
        for (Player player : HardcoreQuestingCore.getServer().m_6846_().m_11314_()) {
            Team team = questingDataManager.getQuestingData(player).getTeam();
            PlayerEntry entry = team.getEntry(player.m_20148_());
            if (entry == null) continue;
            team.refreshTeamData(entry, TeamUpdateSize.ALL);
        }
    }

    @NotNull
    public List<Team> getInvites() {
        return this.invites;
    }

    public List<PlayerEntry> getPlayers() {
        return this.players;
    }

    public List<PlayerEntry> getTeamMembers() {
        return this.players.stream().filter(PlayerEntry::isInTeam).collect(Collectors.toList());
    }

    public void create(String name) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.CREATE, name));
    }

    public void invite(String name) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.INVITE, name));
    }

    public void accept() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.ACCEPT, "" + this.getId()));
    }

    public void decline() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.DECLINE, "" + this.getId()));
    }

    public void kick(UUID playerID) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.KICK, playerID.toString()));
    }

    public void leave() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.LEAVE, ""));
    }

    public void disband() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.DISBAND, ""));
    }

    public void nextLifeSetting() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.NEXT_LIFE_SETTING, ""));
    }

    public void nextRewardSetting() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.NEXT_REWARD_SETTING, ""));
    }

    public boolean isOwner(@NotNull Player player) {
        return this.isOwner(player.m_20148_());
    }

    public boolean isOwner(@Nullable UUID uuid) {
        PlayerEntry entry = this.getEntry(uuid);
        return entry != null && entry.isOwner();
    }

    @Nullable
    public PlayerEntry getEntry(@Nullable UUID uuid) {
        for (PlayerEntry playerEntry : this.getPlayers()) {
            if (!playerEntry.getUUID().equals(uuid)) continue;
            return playerEntry;
        }
        return null;
    }

    private void createReputation() {
        this.reputation = new HashMap<String, Integer>();
        for (Reputation reputation : ReputationManager.getInstance().getReputations().values()) {
            this.createReputation(reputation.getId());
        }
    }

    public int getReputation(Reputation reputation) {
        return this.getReputation(reputation.getId());
    }

    public void setReputation(Reputation reputation, int value) {
        this.setReputation(reputation.getId(), (Integer)value);
    }

    private void createReputation(String id) {
        this.reputation.put(id, 0);
    }

    public int getReputation(String id) {
        Integer value = this.reputation.get(id);
        return value == null ? 0 : value;
    }

    public void setReputation(String id, Integer value) {
        this.reputation.put(id, value);
    }

    private void createQuestData() {
        this.questData = new HashMap<UUID, QuestData>();
        Quest.getQuests().keySet().forEach(this::createQuestData);
    }

    private void createQuestData(UUID questId) {
        this.questData.put(questId, Quest.getQuest(questId).createData(1));
    }

    public QuestData getQuestData(UUID questId) {
        if (!this.questData.containsKey(questId)) {
            this.createQuestData(questId);
        }
        return this.questData.get(questId);
    }

    public void setQuestData(UUID questId, QuestData data) {
        this.questData.put(questId, data);
    }

    public boolean isSingle() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClientTeamLives(int lives) {
        this.clientTeamLives = lives;
    }

    public void update(Team team) {
        this.name = team.name;
        this.questData = team.questData;
        this.reputation = team.reputation;
        this.lifeSetting = team.lifeSetting;
        this.rewardSetting = team.rewardSetting;
        this.players = team.players;
    }

    public static String saveTeam(Player entity) {
        Team team = QuestingDataManager.getInstance().getQuestingData(entity).getTeam();
        if (team.isSingle()) {
            return "";
        }
        return SaveHandler.saveTeam(team);
    }
}

