/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.LifeSetting;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamError;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.team.TeamUpdateSize;
import hardcorequesting.common.forge.team.TeamUpdateType;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TeamAction {
    CREATE{

        @Override
        public void process(Team team, Player player, String teamName) {
            if (team.isSingle()) {
                TeamManager manager = TeamManager.getInstance();
                if (teamName.length() == 0) {
                    return;
                }
                for (Team t : manager.getNamedTeams()) {
                    if (!t.getName().equals(teamName)) continue;
                    TeamError.USED_NAME.sendToClient(player);
                    return;
                }
                team.setId(UUID.randomUUID());
                manager.addTeam(team);
                team.setName(teamName);
                team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                Team.declineAll(player.m_20148_());
                TeamLiteStat.refreshTeam(team);
                NetworkManager.sendToAllPlayers(TeamUpdateType.CREATE_TEAM.build(team, new Object[0]));
                if (player instanceof ServerPlayer) {
                    NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(team, player.m_20148_().toString()), (ServerPlayer)player);
                }
            }
        }
    }
    ,
    INVITE{

        @Override
        public void process(Team team, Player player, String playerName) {
            ServerPlayer invitedPlayer = HardcoreQuestingCore.getServer().m_6846_().m_11255_(playerName);
            if (!team.isSingle() && team.isOwner(player) && invitedPlayer != null) {
                QuestingDataManager manager = QuestingDataManager.getInstance();
                PlayerEntry invitedPlayerEntry = new PlayerEntry(invitedPlayer.m_20148_(), false, false);
                if (!manager.hasData(invitedPlayer.m_20148_())) {
                    TeamError.INVALID_PLAYER.sendToClient(player);
                    return;
                }
                if (!manager.getQuestingData(invitedPlayer.m_20148_()).getTeam().isSingle()) {
                    TeamError.IN_PARTY.sendToClient(player);
                    return;
                }
                if (!team.getPlayers().contains(invitedPlayerEntry)) {
                    team.getPlayers().add(invitedPlayerEntry);
                    team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    manager.getQuestingData(invitedPlayer.m_20148_()).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    manager.getQuestingData(invitedPlayer.m_20148_()).getTeam().getInvites().add(team);
                    NetworkManager.sendToPlayer(TeamUpdateType.INVITE.build(team, new Object[0]), invitedPlayer);
                }
            }
        }
    }
    ,
    ACCEPT{

        @Override
        public void process(Team team, Player player, String data) {
            if (team.isSingle()) {
                UUID acceptId = UUID.fromString(data);
                Team inviteTeam = TeamManager.getInstance().getByTeamId(acceptId);
                if (inviteTeam != null) {
                    int id = 0;
                    for (PlayerEntry entry : inviteTeam.getPlayers()) {
                        QuestData questData;
                        QuestData joinData;
                        if (entry.isInTeam()) {
                            ++id;
                            continue;
                        }
                        if (!entry.getUUID().equals(player.m_20148_())) continue;
                        entry.setInTeam(true);
                        QuestingDataManager.getInstance().getQuestingData(player).setTeam(inviteTeam);
                        for (UUID questId : inviteTeam.getQuestData().keySet()) {
                            joinData = team.getQuestData().get(questId);
                            questData = inviteTeam.getQuestData().get(questId);
                            if (questData == null) continue;
                            questData.insertPlayer(id, joinData.canClaimPlayerReward(0));
                        }
                        for (UUID questId : inviteTeam.getQuestData().keySet()) {
                            joinData = team.getQuestData().get(questId);
                            questData = inviteTeam.getQuestData().get(questId);
                            if (questData == null || Quest.getQuest(questId) == null) continue;
                            Quest.getQuest(questId).mergeProgress(player.m_20148_(), questData, joinData);
                        }
                        for (Reputation reputation : ReputationManager.getInstance().getReputations().values()) {
                            if (reputation == null) continue;
                            int joinValue = team.getReputation(reputation);
                            int teamValue = inviteTeam.getReputation(reputation);
                            int targetValue = Math.abs(joinValue) > Math.abs(teamValue) ? joinValue : teamValue;
                            inviteTeam.setReputation(reputation, targetValue);
                        }
                        inviteTeam.refreshData();
                        Team.declineAll(player.m_20148_());
                        TeamLiteStat.refreshTeam(inviteTeam);
                        NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(inviteTeam, player.m_20148_()), entry.getPlayerMP());
                        break;
                    }
                }
            }
        }
    }
    ,
    DECLINE{

        @Override
        public void process(Team team, Player player, String data) {
            if (team.isSingle()) {
                UUID declineId = UUID.fromString(data);
                TeamManager manager = TeamManager.getInstance();
                Team inviteTeam = manager.getByTeamId(declineId);
                if (inviteTeam != null) {
                    inviteTeam.getPlayers().remove(new PlayerEntry(player.m_20148_(), false, false));
                    inviteTeam.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                    team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                }
            }
        }
    }
    ,
    KICK{

        @Override
        public void process(Team team, Player player, String toRemovePlayerUuid) {
            PlayerEntry entryToRemove;
            ServerPlayer playerToRemove = HardcoreQuestingCore.getServer().m_6846_().m_11259_(UUID.fromString(toRemovePlayerUuid));
            if (!team.isSingle() && team.isOwner(player) && playerToRemove != null && !(entryToRemove = team.getEntry(playerToRemove.m_20148_())).isOwner()) {
                if (entryToRemove.isInTeam()) {
                    team.removePlayer((Player)playerToRemove);
                    team.refreshTeamData(TeamUpdateSize.ALL);
                    TeamLiteStat.refreshTeam(team);
                } else {
                    team.getPlayers().remove(entryToRemove);
                    team.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                }
                QuestingDataManager.getInstance().getQuestingData((Player)playerToRemove).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
            }
        }
    }
    ,
    LEAVE{

        @Override
        public void process(Team team, Player player, String data) {
            if (!team.isSingle() && !team.isOwner(player)) {
                team.removePlayer(player);
                team.refreshTeamData(TeamUpdateSize.ALL);
                TeamAction.getTeam(player).refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                TeamLiteStat.refreshTeam(team);
            }
        }
    }
    ,
    DISBAND{

        @Override
        public void process(Team team, Player player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.deleteTeam();
                TeamLiteStat.refreshTeam(team);
            }
        }
    }
    ,
    NEXT_LIFE_SETTING{

        @Override
        public void process(Team team, Player player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setLifeSetting(LifeSetting.values()[(team.getLifeSetting().ordinal() + 1) % LifeSetting.values().length]);
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    }
    ,
    NEXT_REWARD_SETTING{

        @Override
        public void process(Team team, Player player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setRewardSetting(RewardSetting.values()[(team.getRewardSetting().ordinal() + 1) % RewardSetting.values().length]);
                if (team.getRewardSetting() == RewardSetting.ALL) {
                    team.setRewardSetting(RewardSetting.getDefault());
                }
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    };


    private static Team getTeam(Player player) {
        return QuestingDataManager.getInstance().getQuestingData(player).getTeam();
    }

    public void process(Player player, String data) {
        this.process(TeamAction.getTeam(player), player, data);
    }

    public abstract void process(Team var1, Player var2, String var3);
}

