/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.TeamErrorMessage;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum TeamError {
    INVALID_PLAYER("hqm.team.invalidPlayer.title", "hqm.team.invalidPlayer.desc"),
    IN_PARTY("hqm.team.playerInParty.title", "hqm.team.playerInParty.desc"),
    USED_NAME("hqm.team.usedTeamName.title", "hqm.team.usedTeamName.desc");

    public static TeamError latestError;
    private final String header;
    private final String message;

    private TeamError(String header, String message) {
        this.message = message;
        this.header = header;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedText getMessage() {
        return Translator.translatable(this.message, new Object[0]).m_130940_(ChatFormatting.DARK_RED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedText getHeader() {
        return Translator.translatable(this.header, new Object[0]).m_130940_(ChatFormatting.DARK_RED);
    }

    public void sendToClient(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkManager.sendToPlayer(new TeamErrorMessage(this), (ServerPlayer)player);
        }
    }
}

