/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.TeamStatsMessage;
import hardcorequesting.common.forge.team.Team;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamLiteStat {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, TeamLiteStat> clientTeams = new HashMap<String, TeamLiteStat>();
    @Nullable
    private static List<TeamLiteStat> clientTeamsList;
    private static final Comparator<TeamLiteStat> teamComparator;
    private final String name;
    private final int players;
    private final int lives;
    private final float progress;

    public TeamLiteStat(String name, int players, int lives, float progress) {
        this.name = name;
        this.players = players;
        this.lives = lives;
        this.progress = progress;
    }

    public static void refreshTeam(Team team) {
        NetworkManager.sendToAllPlayers(new TeamStatsMessage(team));
    }

    public static void updateTeams(List<TeamLiteStat> stats) {
        clientTeams.clear();
        for (TeamLiteStat stat : stats) {
            if (stat.getPlayers() <= 0) continue;
            clientTeams.put(stat.name, stat);
        }
        TeamLiteStat.updateTeams();
    }

    public static void updateTeam(TeamLiteStat stat) {
        if (stat.getPlayers() > 0) {
            clientTeams.put(stat.name, stat);
        } else {
            clientTeams.remove(stat.name);
        }
        TeamLiteStat.updateTeams();
    }

    private static void updateTeams() {
        clientTeamsList = clientTeams.values().stream().sorted(teamComparator).toList();
    }

    @NotNull
    public static List<TeamLiteStat> getTeamStats() {
        if (clientTeamsList == null) {
            LOGGER.warn("Tried getting client teams list before getting them from the server. The initial packet might have failed to be sent!");
            clientTeamsList = Collections.emptyList();
        }
        return clientTeamsList;
    }

    public String getName() {
        return this.name;
    }

    public int getPlayers() {
        return this.players;
    }

    public int getLives() {
        return this.lives;
    }

    public float getProgress() {
        return this.progress;
    }

    static {
        teamComparator = Comparator.comparingDouble(TeamLiteStat::getProgress).reversed();
    }
}

