/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.io.adapter.TeamAdapter;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamLiteStat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamManager
extends SimpleSerializable {
    public static final String FILE_PATH = "teams.json";
    private final Set<Team> teams = Sets.newConcurrentHashSet();

    public static TeamManager getInstance() {
        return QuestLine.getActiveQuestLine().teamManager;
    }

    @Override
    public String filePath() {
        return FILE_PATH;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void clear() {
        this.teams.clear();
        TeamAdapter.clearInvitesMap();
    }

    @Override
    public void loadFromString(String string) {
        List teams = SaveHandler.load(string, new TypeToken<List<Team>>(){}.getType()).orElseGet(Lists::newArrayList);
        teams.stream().filter(team -> team != null && !team.isSingle()).forEach(TeamManager.getInstance()::addTeam);
        TeamAdapter.commitInvitesMap();
        if (HardcoreQuestingCore.platform.isClient()) {
            TeamLiteStat.updateTeams(teams.stream().map(Team::toLiteStat).collect(Collectors.toList()));
        }
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.teams, new TypeToken<Collection<Team>>(){}.getType());
    }

    public String saveToString(Player player) {
        Team team = QuestingDataManager.getInstance().getQuestingData(player).getTeam();
        if (team.isSingle()) {
            return "[]";
        }
        return "[" + SaveHandler.save(team, Team.class) + "]";
    }

    @Nullable
    public Team getByTeamId(UUID uuid) {
        for (Team team : this.teams) {
            if (!team.getId().equals(uuid)) continue;
            return team;
        }
        return null;
    }

    @NotNull
    public Team getByPlayer(UUID playerId) {
        for (Team team : this.teams) {
            for (PlayerEntry player : team.getPlayers()) {
                if (!player.getUUID().equals(playerId)) continue;
                return team;
            }
        }
        return Team.single(playerId);
    }

    public Iterable<Team> getNamedTeams() {
        return this.teams;
    }

    public Iterable<Team> getTeams() {
        Iterable singleTeams = QuestingDataManager.getInstance().getQuestingData().values().stream().map(QuestingData::getTeam).filter(Team::isSingle).collect(Collectors.toSet());
        return Iterables.concat(this.teams, (Iterable)singleTeams);
    }

    public void deactivate() {
        this.teams.clear();
    }

    public void addTeam(Team team) {
        if (team.isSingle()) {
            throw new IllegalArgumentException("Single teams can not be added!");
        }
        this.teams.add(team);
    }

    public void removeTeam(Team team) {
        if (team == null) {
            return;
        }
        if (team.isSingle()) {
            throw new IllegalArgumentException("Single teams can not be deleted!");
        }
        this.teams.removeIf(t -> t.getId().equals(team.getId()));
    }
}

