/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.team;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.io.adapter.TeamAdapter;
import hardcorequesting.common.forge.network.message.TeamUpdateMessage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.UUID;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TeamUpdateType {
    FULL{

        @Override
        public void update(Team team, String data) {
            try {
                team.update((Team)TeamAdapter.TEAM_ADAPTER.fromJson(data));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson(team));
        }
    }
    ,
    LIVES{

        @Override
        public void update(Team team, String data) {
            team.setClientTeamLives(Integer.parseInt(data));
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, "" + team.getSharedLives());
        }
    }
    ,
    REPUTATION_RECEIVED{
        private static final String QUEST = "quest";
        private static final String REPUTATIONS = "reputations";
        private static final String ID = "id";
        private static final String VAL = "val";

        @Override
        public void update(Team team, String data) {
            QuestData questData;
            JsonParser parser = new JsonParser();
            JsonObject object = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(UUID.fromString(object.get(QUEST).getAsString()));
            if (quest != null && (questData = team.getQuestData(quest.getQuestId())) != null) {
                questData.teamRewardClaimed = true;
                for (JsonElement element : object.get(REPUTATIONS).getAsJsonArray()) {
                    String id = element.getAsJsonObject().get(ID).getAsString();
                    int val = element.getAsJsonObject().get(VAL).getAsInt();
                    team.setReputation(id, (Integer)val);
                }
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            StringWriter out = new StringWriter();
            try {
                JsonWriter writer = new JsonWriter((Writer)out);
                writer.beginObject();
                writer.name(QUEST).value(((Quest)data[0]).getQuestId().toString());
                writer.name(REPUTATIONS).beginArray();
                for (ReputationReward reward : (List)data[1]) {
                    writer.beginObject();
                    writer.name(ID).value(((Reputation)reward.getReward()).getId());
                    writer.name(VAL).value((long)team.getReputation((Reputation)reward.getReward()));
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new TeamUpdateMessage(this, out.toString());
        }
    }
    ,
    CREATE_TEAM{

        @Override
        public void update(Team team, String data) {
            try {
                Team newTeam = (Team)TeamAdapter.TEAM_ADAPTER.fromJson(data);
                TeamManager.getInstance().addTeam(newTeam);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson(team));
        }
    }
    ,
    JOIN_TEAM{

        @Override
        public void update(Team team, String data) {
            String uuid = data.substring(0, 36);
            String teamJson = data.substring(36);
            try {
                Team joinedTeam = (Team)TeamAdapter.TEAM_ADAPTER.fromJson(teamJson);
                TeamManager.getInstance().removeTeam(joinedTeam);
                TeamManager.getInstance().addTeam(joinedTeam);
                QuestingDataManager.getInstance().getQuestingData(UUID.fromString(uuid)).setTeam(joinedTeam);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, data[0].toString() + TeamAdapter.TEAM_ADAPTER.toJson(team));
        }
    }
    ,
    LEAVE_TEAM{

        @Override
        public void update(Team team, String data) {
            String uuid = data.substring(0, 36);
            String teamJson = data.substring(36);
            try {
                QuestingDataManager.getInstance().getQuestingData(UUID.fromString(uuid)).setTeam((Team)TeamAdapter.TEAM_ADAPTER.fromJson(teamJson));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, data[0].toString() + TeamAdapter.TEAM_ADAPTER.toJson((Team)data[1]));
        }
    }
    ,
    REMOVE_TEAM{

        @Override
        public void update(Team clientTeam, String data) {
            UUID id = UUID.fromString(data);
            TeamManager.getInstance().removeTeam(TeamManager.getInstance().getByTeamId(id));
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, "" + team.getId());
        }
    }
    ,
    INVITE{

        @Override
        public void update(Team clientTeam, String data) {
            try {
                Team team = (Team)TeamAdapter.TEAM_ADAPTER.fromJson(data);
                TeamManager.getInstance().removeTeam(team);
                TeamManager.getInstance().addTeam(team);
                clientTeam.getInvites().add(team);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson(team));
        }
    };


    public abstract void update(Team var1, String var2);

    public abstract TeamUpdateMessage build(Team var1, Object ... var2);
}

