/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.blocks.DeliveryBlock;
import hardcorequesting.common.forge.blocks.ModBlocks;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBarrelBlockEntity
extends BlockEntity
implements Container {
    private static final String NBT_PLAYER_UUID = "Player";
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_TASK = "Task";
    private UUID selectedQuestId;
    public int selectedTask;
    private UUID playerId;

    public AbstractBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.typeBarrel.get(), pos, state);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int i, @NotNull ItemStack stack) {
        QuestTask<?> task = this.getCurrentTask();
        if (task instanceof ConsumeItemTask) {
            ConsumeItemTask consumeTask = (ConsumeItemTask)task;
            NonNullList list = NonNullList.m_122779_();
            list.add((Object)stack);
            if (consumeTask.increaseItems((NonNullList<ItemStack>)list, this.getPlayerUUID())) {
                this.updateState();
                this.doSync();
            }
        }
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_5856_(@NotNull Player player) {
    }

    public void m_5785_(@NotNull Player player) {
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        QuestTask<?> task = this.getCurrentTask();
        if (task instanceof ConsumeItemTask) {
            return ((ConsumeItemTask)task).canTakeItem(stack, this.getPlayerUUID());
        }
        return false;
    }

    public void m_6211_() {
    }

    public void doSync() {
        if (!this.f_58857_.m_5776_()) {
            Player player;
            ServerLevel world = (ServerLevel)this.m_58904_();
            world.m_7726_().m_8450_(this.m_58899_());
            QuestTask<?> task = this.getCurrentTask();
            if (task != null && (player = QuestingData.getPlayer(this.getPlayerUUID())) != null) {
                task.getParent().sendUpdatedDataToTeam(player);
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void updateState() {
        if (!this.f_58857_.f_46443_) {
            QuestTask<?> task = this.getCurrentTask();
            boolean bound = false;
            if (task != null && !task.isCompleted(this.getPlayerUUID())) {
                bound = true;
            }
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)ModBlocks.blockBarrel.get().m_49966_().m_61124_((Property)DeliveryBlock.BOUND, (Comparable)Boolean.valueOf(bound)), 3);
        }
    }

    public QuestTask<?> getCurrentTask() {
        Quest quest;
        if (this.getPlayerUUID() != null && this.selectedQuestId != null && (quest = Quest.getQuest(this.selectedQuestId)) != null && this.selectedTask >= 0 && this.selectedTask < quest.getTasks().size()) {
            return quest.getTasks().get(this.selectedTask);
        }
        return null;
    }

    public void storeSettings(Player player) {
        this.setPlayerUUID(player.m_20148_());
        QuestingData data = QuestingDataManager.getInstance().getQuestingData(this.getPlayerUUID());
        this.setQuestUUID(data.selectedQuestId);
        this.selectedTask = data.selectedTask;
        QuestTask<?> task = this.getCurrentTask();
        if (task == null || task.isCompleted(this.getPlayerUUID())) {
            this.setPlayerUUID(null);
            this.setQuestUUID(null);
            this.selectedTask = 0;
        }
        this.doSync();
        this.updateState();
    }

    public UUID getPlayerUUID() {
        return this.playerId;
    }

    public void setPlayerUUID(UUID playerId) {
        this.playerId = playerId;
    }

    public UUID getQuestUUID() {
        return this.selectedQuestId;
    }

    public void setQuestUUID(UUID questId) {
        this.selectedQuestId = questId;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.getPlayerUUID() != null && this.selectedQuestId != null) {
            compoundTag.m_128362_(NBT_PLAYER_UUID, this.getPlayerUUID());
            compoundTag.m_128362_(NBT_QUEST, this.getQuestUUID());
            compoundTag.m_128344_(NBT_TASK, (byte)this.selectedTask);
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("PlayerMost")) {
            this.setPlayerUUID(compoundTag.m_128342_(NBT_PLAYER_UUID));
            this.setQuestUUID(compoundTag.m_128342_(NBT_QUEST));
            this.selectedTask = compoundTag.m_128445_(NBT_TASK);
        }
    }
}

